/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh;

import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.dialogs.PasswordDialog;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Container;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.JameicaCompat;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportRDHNew;

public class KeyPasswordLoadDialog
extends PasswordDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private String filename = null;

    public KeyPasswordLoadDialog(HBCIPassport passport, String password) {
        super(1);
        this.setSize(550, -1);
        if (password != null && password.length() > 0) {
            try {
                JameicaCompat.set((Object)this, password, "setPassword", "enteredPassword");
            }
            catch (Exception e) {
                Logger.error((String)"unable to apply password", (Throwable)e);
            }
        }
        String s = null;
        try {
            Konto konto;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeSession session = ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).getCurrentSession();
            Konto konto2 = konto = session != null ? session.getKonto() : null;
            if (konto != null) {
                s = konto.getBezeichnung();
                String name = HBCIProperties.getNameForBank(konto.getBLZ());
                if (name != null && name.length() > 0) {
                    s = String.valueOf(s) + " [" + name + "]";
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine current konto", (Throwable)e);
        }
        String text = null;
        if (s != null) {
            this.setTitle(i18n.tr("Schl\u00fcsseldatei. Konto: {0}", s));
            text = i18n.tr("Bitte geben Sie das Passwort der Schl\u00fcsseldatei ein.\nKonto: {0}", s);
        } else {
            this.setTitle(i18n.tr("Schl\u00fcsseldatei"));
            text = i18n.tr("Bitte geben Sie das Passwort der Schl\u00fcsseldatei ein.");
        }
        if (passport != null && passport instanceof HBCIPassportRDHNew) {
            this.filename = ((HBCIPassportRDHNew)passport).getFilename();
        }
        this.setText(text);
        this.setLabelText(i18n.tr("Ihr Passwort"));
    }

    protected void extend(Container container) throws Exception {
        if (this.filename == null) {
            return;
        }
        Part p = new Part(){

            public void paint(Composite parent) throws RemoteException {
                String text = i18n.tr("Schl\u00fcsseldatei: {0}", KeyPasswordLoadDialog.this.filename);
                final Label comment = new Label(parent, 64);
                comment.setText(text);
                comment.setForeground(Color.COMMENT.getSWTColor());
                comment.setLayoutData((Object)new GridData(1808));
                comment.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        comment.setSize(comment.computeSize(comment.getSize().x, -1));
                    }
                });
            }
        };
        container.addPart(p);
    }

    protected boolean checkPassword(String password) {
        if (password == null || password.length() == 0) {
            this.setErrorText(String.valueOf(i18n.tr("Fehler: Bitte geben Sie Ihr Passwort ein.")) + " " + this.getRetryString());
            return false;
        }
        return true;
    }

    private String getRetryString() {
        String retries = this.getRemainingRetries() > 1 ? i18n.tr("Versuche") : i18n.tr("Versuch");
        return String.valueOf(i18n.tr("Noch")) + " " + this.getRemainingRetries() + " " + retries + ".";
    }
}

