/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh;

import de.willuhn.jameica.gui.dialogs.NewPasswordDialog;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportRDHXFile;

public class KeyPasswordSaveDialog
extends NewPasswordDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final char[] INVALID_CHARS = new char[]{'\u00a7', '\u00b0', '\u00b4', '\u00c4', '\u00d6', '\u00dc', '\u00df', '\u00e4', '\u00f6', '\u00fc'};

    public KeyPasswordSaveDialog(int position, HBCIPassport passport) {
        super(position);
        this.setTitle(i18n.tr("Passwort-Eingabe"));
        this.setLabelText(i18n.tr("Ihr Passwort"));
        String text = i18n.tr("Bitte vergeben Sie ein Passwort, mit dem der zu speichernde\nSchl\u00fcssel gesch\u00fctzt werden soll.");
        text = passport instanceof HBCIPassportRDHXFile ? String.valueOf(text) + "\n\n" + i18n.tr("Geben Sie bitte mindestens 8 Zeichen ein.") : String.valueOf(text) + "\n\n" + i18n.tr("Die folgenden Zeichen d\u00fcrfen nicht enthalten sein: {0}", String.copyValueOf(INVALID_CHARS));
        this.setText(String.valueOf(text) + "\n");
    }

    protected boolean checkPassword(String password, String password2) {
        if (!super.checkPassword(password, password2)) {
            return false;
        }
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            char[] cArray2 = INVALID_CHARS;
            int n3 = INVALID_CHARS.length;
            int n4 = 0;
            while (n4 < n3) {
                char test = cArray2[n4];
                if (test == c) {
                    this.setErrorText(i18n.tr("Das folgende Zeichen darf nicht enthalten sein: {0}", String.valueOf(test)));
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }
}

