/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passports.rdh.KeyFormatDialog;
import de.willuhn.jameica.hbci.passports.rdh.SelectKeyDialog;
import de.willuhn.jameica.hbci.passports.rdh.keyformat.KeyFormat;
import de.willuhn.jameica.hbci.passports.rdh.rmi.RDHKey;
import de.willuhn.jameica.hbci.passports.rdh.server.RDHKeyImpl;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.MultipleClassLoader;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;

public class RDHKeyFactory {
    private static Settings settings = new Settings(RDHKeyFactory.class);
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public static KeyFormat[] getKeyFormats(int neededFeature) {
        ArrayList<KeyFormat> list = new ArrayList<KeyFormat>();
        try {
            Class[] classes;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            MultipleClassLoader loader = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader();
            Class[] classArray = classes = loader.getClassFinder().findImplementors(KeyFormat.class);
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    KeyFormat format = (KeyFormat)service.get(c);
                    if (format.hasFeature(neededFeature)) {
                        list.add(format);
                    }
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load key format " + c + " - skipping"), (Throwable)e);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException cne) {
            Logger.error((String)"no key formats found", (Throwable)cne);
        }
        catch (Exception e) {
            Logger.error((String)"error while loading key formats", (Throwable)e);
        }
        Collections.sort(list);
        return list.toArray(new KeyFormat[0]);
    }

    public static void importKey(File f) {
        Logger.info((String)("import rdh key " + f));
        if (f == null) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"), 1));
            return;
        }
        if (!f.canRead() || !f.isFile()) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Schl\u00fcsseldatei {0} nicht lesbar", f.getAbsolutePath()), 1));
            return;
        }
        if (!f.canWrite()) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Schreibrechte fehlen auf Schl\u00fcsseldatei {0}", f.getAbsolutePath()), 1));
            return;
        }
        try {
            KeyFormatDialog d = new KeyFormatDialog(1, 1);
            KeyFormat format = (KeyFormat)d.open();
            Logger.info((String)("registering key, type " + format.getName() + ", " + format.getClass().getName()));
            RDHKeyFactory.addKey(format.importKey(f));
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Schl\u00fcsseldatei erfolgreich importiert"), 0));
        }
        catch (OperationCanceledException oce) {
            Logger.warn((String)("operation cancelled; " + oce.getMessage()));
            throw oce;
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr(ae.getMessage()), 1));
        }
        catch (Throwable t) {
            Logger.error((String)"error while importing key", (Throwable)t);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Import des Schl\u00fcssels: {0}", t.getMessage()), 1));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean createKey(File f) {
        try {
            Logger.info((String)("creating new key in " + f));
            if (f == null) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"), 1));
                return false;
            }
            try {
                String path = f.getCanonicalPath();
                String systemPath = new File(".").getCanonicalPath();
                if (path.startsWith(systemPath)) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte w\u00e4hlen Sie eine Datei, die sich ausserhalb des Programm-Verzeichnisses befindet"), 1));
                    return false;
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to check canonical path", (Throwable)e);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Datei nicht ausw\u00e4hlbar: {0}", e.getMessage()), 1));
                return false;
            }
            int ft = 2;
            KeyFormat[] formats = RDHKeyFactory.getKeyFormats(2);
            KeyFormat format = null;
            if (formats != null && formats.length == 1) {
                format = formats[0];
                Logger.info((String)("only have one key format, that supports creation of new keys, choosing this one automatically: " + format.getName()));
            } else {
                Logger.info((String)"asking user which key format to be used");
                KeyFormatDialog d = new KeyFormatDialog(1, 2);
                format = (KeyFormat)d.open();
            }
            RDHKeyFactory.addKey(format.createKey(f));
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Schl\u00fcsseldatei erfolgreich erstellt"), 0));
            return true;
        }
        catch (OperationCanceledException oce) {
            Logger.warn((String)("operation cancelled; " + oce.getMessage()));
            throw oce;
        }
        catch (ApplicationException ae) {
            Logger.error((String)ae.getMessage());
            GUI.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
                }
            });
            return false;
        }
        catch (Throwable t) {
            Logger.error((String)"error while creating key", (Throwable)t);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Erzeugen des Schl\u00fcssels: {0}", t.getMessage()), 1));
        }
        return false;
    }

    public static synchronized RDHKey findByKonto(Konto konto) throws RemoteException, ApplicationException, OperationCanceledException {
        GenericIterator i = RDHKeyFactory.getKeys();
        if (!i.hasNext()) {
            throw new ApplicationException(i18n.tr("Bitte erstellen Sie zuerst eine Schl\u00fcsseldatei"));
        }
        RDHKey key = null;
        ArrayList<RDHKey> keys = new ArrayList<RDHKey>();
        while (i.hasNext()) {
            key = (RDHKey)i.next();
            if (!key.isEnabled()) continue;
            Konto[] verdrahtet = key.getKonten();
            if (konto != null && verdrahtet != null && verdrahtet.length > 0) {
                int j = 0;
                while (j < verdrahtet.length) {
                    Konto k = verdrahtet[j];
                    if (konto.equals((GenericObject)k)) {
                        Logger.info((String)("found config via account. url: " + key.getFilename()));
                        return key;
                    }
                    ++j;
                }
            }
            keys.add(key);
        }
        if (keys.size() == 1) {
            return (RDHKey)keys.get(0);
        }
        if (Application.inServerMode()) {
            throw new ApplicationException(i18n.tr("Zu verwendende Schl\u00fcsseldatei nicht eindeutig ermittelbar. Bitte fest verkn\u00fcpfen"));
        }
        SelectKeyDialog d = new SelectKeyDialog(1);
        try {
            return (RDHKey)d.open();
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            Logger.error((String)"error while choosing key", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler bei der Auswahl der Schl\u00fcsseldatei"));
        }
    }

    public static synchronized GenericIterator getKeys() throws RemoteException {
        String[] found = settings.getList("key", new String[0]);
        ArrayList<RDHKeyImpl> readable = new ArrayList<RDHKeyImpl>();
        int i = 0;
        while (i < found.length) {
            if (found[i] != null && found[i].length() != 0) {
                readable.add(new RDHKeyImpl(new File(found[i])));
            }
            ++i;
        }
        return PseudoIterator.fromArray((GenericObject[])readable.toArray(new RDHKey[0]));
    }

    public static void addKey(RDHKey key) throws Exception {
        if (key == null) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"), 1));
            return;
        }
        String file = key.getFilename();
        Logger.info((String)("adding key " + file + " to list"));
        String[] existing = settings.getList("key", new String[0]);
        if (existing.length == 0) {
            settings.setAttribute("key", new String[]{file});
            return;
        }
        String[] newList = new String[existing.length + 1];
        System.arraycopy(existing, 0, newList, 0, existing.length);
        newList[existing.length] = file;
        settings.setAttribute("key", newList);
    }

    public static void removeKey(RDHKey key) throws ApplicationException {
        if (key == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"));
        }
        try {
            Logger.warn((String)("removing key " + key.getFilename() + " from key registry"));
            String[] existing = settings.getList("key", new String[0]);
            ArrayList<String> newList = new ArrayList<String>();
            if (existing.length == 0) {
                return;
            }
            File file = new File(key.getFilename());
            int i = 0;
            while (i < existing.length) {
                File f = new File(existing[i]);
                if (file.equals(f)) {
                    Logger.info((String)("removing key " + f.getAbsolutePath() + " from list"));
                } else {
                    newList.add(f.getAbsolutePath());
                }
                ++i;
            }
            settings.setAttribute("key", newList.toArray(new String[0]));
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to remove key", (Throwable)re);
            throw new ApplicationException(i18n.tr("L\u00f6schen fehlgeschlagen: {0}", re.getMessage()));
        }
    }
}

