/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passports.rdh.RDHKeyFactory;
import de.willuhn.jameica.hbci.passports.rdh.rmi.RDHKey;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class SelectKeyDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private TablePart table = null;
    private RDHKey selected = null;

    public SelectKeyDialog(int position) {
        super(position);
        this.setTitle(i18n.tr("Schl\u00fcsselauswahl"));
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent);
        container.addText(i18n.tr("Bitte w\u00e4hlen Sie den zu verwendenden Schl\u00fcssel aus"), true);
        final Button apply = new Button(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new Apply().handleAction(SelectKeyDialog.this.table.getSelection());
            }
        }, null, true, "ok.png");
        apply.setEnabled(false);
        GenericIterator list = RDHKeyFactory.getKeys();
        ArrayList<KeyObject> l = new ArrayList<KeyObject>();
        while (list.hasNext()) {
            RDHKey key = (RDHKey)list.next();
            l.add(new KeyObject(key));
        }
        this.table = new TablePart(l, new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new Apply().handleAction(context);
            }
        });
        this.table.setFormatter(new TableFormatter(){

            public void format(TableItem item) {
                if (item == null || item.getData() == null) {
                    return;
                }
                try {
                    KeyObject o = (KeyObject)item.getData();
                    if (!o.key.isEnabled()) {
                        item.setForeground(Color.COMMENT.getSWTColor());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"error while formatting line", (Throwable)e);
                }
            }
        });
        this.table.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                apply.setEnabled(SelectKeyDialog.this.table.getSelection() != null);
            }
        });
        this.table.addColumn(i18n.tr("Dateiname"), "filename");
        this.table.addColumn(i18n.tr("Alias-Name"), "alias");
        this.table.setMulti(false);
        this.table.setSummary(false);
        this.table.paint(parent);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(apply);
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        buttons.paint(parent);
    }

    protected Object getData() throws Exception {
        return this.selected;
    }

    private class Apply
    implements Action {
        private Apply() {
        }

        public void handleAction(Object context) throws ApplicationException {
            if (context == null || !(context instanceof KeyObject)) {
                Logger.warn((String)"no key choosen");
                return;
            }
            KeyObject key = (KeyObject)context;
            try {
                if (!key.key.isEnabled()) {
                    Logger.warn((String)"choosen key not enabled");
                    return;
                }
            }
            catch (RemoteException e) {
                Logger.error((String)"error while checking if key is enabled", (Throwable)e);
            }
            SelectKeyDialog.this.selected = key.key;
            SelectKeyDialog.this.close();
        }
    }

    private class KeyObject
    implements GenericObject {
        private RDHKey key = null;

        private KeyObject(RDHKey key) {
            this.key = key;
        }

        public Object getAttribute(String attribute) throws RemoteException {
            if ("filename".equals(attribute)) {
                return this.key.getFilename();
            }
            if ("alias".equals(attribute)) {
                return this.key.getAlias();
            }
            return null;
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"filename", "alias"};
        }

        public String getID() throws RemoteException {
            return this.key.getFilename();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "filename";
        }

        public boolean equals(GenericObject arg0) throws RemoteException {
            if (arg0 == null) {
                return false;
            }
            return this.getID().equals(arg0.getID());
        }
    }
}

