/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.Composite;

public class SelectSizEntryDialog
extends AbstractDialog {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private String data = null;
    private Entry selected = null;

    public SelectSizEntryDialog(int position, String data) {
        super(position);
        this.data = data;
        this.setTitle(i18n.tr("Schl\u00fcsselauswahl"));
    }

    protected void paint(Composite parent) throws Exception {
        SimpleContainer group = new SimpleContainer(parent);
        group.addText(i18n.tr("Bitte w\u00e4hlen Sie den zu verwendenden Schl\u00fcssel aus"), true);
        ArrayList<Entry> list = new ArrayList<Entry>();
        StringTokenizer tok = new StringTokenizer(this.data, "|");
        while (tok.hasMoreTokens()) {
            Entry e = new Entry(tok.nextToken());
            list.add(e);
        }
        final TablePart table = new TablePart(list, new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Entry e;
                if (context == null || !(context instanceof Entry)) {
                    return;
                }
                SelectSizEntryDialog.this.selected = e = (Entry)context;
                SelectSizEntryDialog.this.close();
            }
        });
        table.addColumn(i18n.tr("Bank"), "bank");
        table.addColumn(i18n.tr("Benutzerkennung"), "user");
        table.setMulti(false);
        table.setSummary(false);
        table.paint(parent);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                Entry e;
                Object o = table.getSelection();
                if (o == null || !(o instanceof Entry)) {
                    return;
                }
                SelectSizEntryDialog.this.selected = e = (Entry)context;
                SelectSizEntryDialog.this.close();
            }
        }, null, false, "ok.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        buttons.paint(parent);
    }

    protected Object getData() throws Exception {
        return this.selected.getId();
    }

    public class Entry {
        private String id = null;
        private String userid = null;
        private String bank = null;

        private Entry(String data) {
            StringTokenizer tok = new StringTokenizer(data, ";");
            this.id = tok.nextToken();
            this.bank = tok.nextToken();
            this.userid = tok.nextToken();
            try {
                String bankName = HBCIProperties.getNameForBank(this.bank);
                if (bankName != null && bankName.length() > 0) {
                    this.bank = String.valueOf(this.bank) + " [" + bankName + "]";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getUser() {
            return this.userid;
        }

        public String getBank() {
            return this.bank;
        }

        public String getId() {
            return this.id;
        }
    }
}

