/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh.keyformat;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.passports.rdh.keyformat.AbstractKeyFormat;
import de.willuhn.jameica.hbci.passports.rdh.rmi.RDHKey;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.PluginResources;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;

public abstract class AbstractSizRdhFormat
extends AbstractKeyFormat {
    protected static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public RDHKey createKey(File file) throws ApplicationException, OperationCanceledException {
        throw new ApplicationException(i18n.tr("Das Erstellen von neuen Schl\u00fcsseln wird f\u00fcr dieses Format nicht unterst\u00fctzt"));
    }

    @Override
    public boolean hasFeature(int feature) {
        switch (feature) {
            case 2: {
                return false;
            }
            case 1: {
                int os = Application.getPlatform().getOS();
                return os == 1 || os == 2;
            }
        }
        Logger.warn((String)("unknown feature " + feature));
        return false;
    }

    protected static String getRDHLib() throws ApplicationException {
        AbstractPlugin p = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
        PluginResources res = p.getResources();
        Settings settings = res.getSettings();
        Manifest mf = p.getManifest();
        String file = null;
        switch (Application.getPlatform().getOS()) {
            case 1: {
                file = settings.getString("sizrdh.nativelib", "libhbci4java-sizrdh-linux-gcc3.so");
                break;
            }
            case 2: {
                file = settings.getString("sizrdh.nativelib", "hbci4java-sizrdh-win32.dll");
            }
        }
        if (file == null) {
            throw new ApplicationException(res.getI18N().tr("SizRDH-Schl\u00fcsseldateien werden f\u00fcr Ihr Betriebssystem nicht von Hibiscus unterst\u00fctzt"));
        }
        file = String.valueOf(mf.getPluginDir()) + File.separator + "lib" + File.separator + file;
        Logger.info((String)("using sizrdh native lib " + file));
        return file;
    }
}

