/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh.keyformat;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCICallbackSWT;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.gui.DialogFactory;
import de.willuhn.jameica.hbci.passports.rdh.InsertKeyDialog;
import de.willuhn.jameica.hbci.passports.rdh.keyformat.AbstractKeyFormat;
import de.willuhn.jameica.hbci.passports.rdh.rmi.RDHKey;
import de.willuhn.jameica.hbci.passports.rdh.server.PassportHandleImpl;
import de.willuhn.jameica.hbci.passports.rdh.server.RDHKeyImpl;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.RemoteException;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.InvalidPassphraseException;
import org.kapott.hbci.exceptions.NeedKeyAckException;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class HBCI4JavaFormat
extends AbstractKeyFormat {
    protected static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public String getName() {
        return i18n.tr("HBCI4Java/Hibiscus-Format (RDH)");
    }

    @Override
    public boolean hasFeature(int feature) {
        switch (feature) {
            case 2: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        Logger.warn((String)("unknown feature " + feature));
        return false;
    }

    @Override
    public RDHKey importKey(File file) throws ApplicationException, OperationCanceledException {
        if (file == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"));
        }
        if (!file.canRead() || !file.isFile()) {
            throw new ApplicationException(i18n.tr("Schl\u00fcsseldatei nicht lesbar"));
        }
        try {
            RDHKeyImpl key = new RDHKeyImpl(file);
            key.setFormat(this);
            return key;
        }
        catch (RemoteException re) {
            Logger.error((String)("unable to import key " + file.getAbsolutePath()), (Throwable)re);
            throw new ApplicationException(i18n.tr("Schl\u00fcsseldatei kann nicht importiert werden: {0}", re.getMessage()));
        }
    }

    @Override
    public RDHKey createKey(File file) throws ApplicationException, OperationCanceledException {
        HBCIHandler handler = null;
        RDHKeyImpl key = null;
        try {
            key = new RDHKeyImpl(file);
            key.setFormat(this);
            HBCIPassport passport = this.load(key, true);
            passport.saveChanges();
            passport.syncSigId();
            passport.syncSysId();
            QueryMessage msg = new QueryMessage((Object)passport);
            Application.getMessagingFactory().getMessagingQueue("hibiscus.passport.rdh.hbciversion").sendSyncMessage((Message)msg);
            Object data = msg.getData();
            if (data == null || !(data instanceof String)) {
                throw new ApplicationException(i18n.tr("HBCI-Version nicht ermittelbar"));
            }
            String version = (String)msg.getData();
            Logger.info((String)("using hbci version: " + version));
            handler = new HBCIHandler(version, passport);
            handler.close();
            handler = null;
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Schl\u00fcssel erfolgreich erstellt"), 0));
            RDHKeyImpl rDHKeyImpl = key;
            return rDHKeyImpl;
        }
        catch (OperationCanceledException | ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            OperationCanceledException oce = (OperationCanceledException)HBCIProperties.getCause(e, OperationCanceledException.class);
            if (oce != null) {
                throw oce;
            }
            ApplicationException ae = (ApplicationException)HBCIProperties.getCause(e, ApplicationException.class);
            if (ae != null) {
                throw ae;
            }
            NeedKeyAckException ack = (NeedKeyAckException)HBCIProperties.getCause(e, NeedKeyAckException.class);
            if (ack != null) {
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Schl\u00fcssel erfolgreich erstellt"), 0));
                String msg = i18n.tr("Bitte senden Sie den INI-Brief an Ihre Bank\nund warten Sie auf die Freischaltung durch die Bank.");
                try {
                    Application.getCallback().notifyUser(msg);
                }
                catch (Exception e2) {
                    Logger.error((String)"unable to notify user", (Throwable)e2);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(msg, 0));
                }
                RDHKeyImpl rDHKeyImpl = key;
                return rDHKeyImpl;
            }
            Logger.error((String)("unable to create key " + file.getAbsolutePath()), (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Schl\u00fcssels: {0}", e.getMessage()));
        }
        finally {
            try {
                if (handler != null) {
                    handler.close();
                }
            }
            catch (Throwable t) {
                Logger.error((String)"error while closing handler", (Throwable)t);
            }
        }
    }

    @Override
    public HBCIPassport load(RDHKey key) throws ApplicationException, OperationCanceledException {
        return this.load(key, false);
    }

    String getPassportType() {
        return "RDHNew";
    }

    private HBCIPassport load(RDHKey key, boolean create) throws ApplicationException, OperationCanceledException {
        HBCICallback callback = null;
        try {
            String filename = key.getFilename();
            if (create) {
                Logger.info((String)("create " + this.getPassportType() + " key " + filename));
            } else {
                InsertKeyDialog kd;
                Boolean b;
                Logger.info((String)("load " + this.getPassportType() + " key " + filename));
                File f = new File(filename);
                if (!(f.exists() || (b = (Boolean)(kd = new InsertKeyDialog(f)).open()) != null && b.booleanValue())) {
                    throw new OperationCanceledException(i18n.tr("Schl\u00fcsseldatei nicht eingelegt oder nicht lesbar"));
                }
            }
            HBCI plugin = (HBCI)Application.getPluginLoader().getPlugin(HBCI.class);
            callback = plugin.getHBCICallback();
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(new PassportHandleImpl());
            } else {
                Logger.warn((String)("unable to register current handle, callback: " + callback));
            }
            String type = this.getPassportType();
            HBCIUtils.setParam((String)"client.passport.default", (String)type);
            HBCIUtils.setParam((String)("client.passport." + type + ".filename"), (String)filename);
            HBCIUtils.setParam((String)("client.passport." + type + ".init"), (String)"1");
            HBCIPassport hBCIPassport = AbstractHBCIPassport.getInstance((String)type);
            return hBCIPassport;
        }
        catch (Exception e) {
            OperationCanceledException oce = (OperationCanceledException)HBCIProperties.getCause(e, OperationCanceledException.class);
            if (oce != null) {
                throw oce;
            }
            DialogFactory.clearPINCache(null);
            ApplicationException ae = (ApplicationException)HBCIProperties.getCause(e, ApplicationException.class);
            if (ae != null) {
                throw ae;
            }
            NeedKeyAckException ack = (NeedKeyAckException)HBCIProperties.getCause(e, NeedKeyAckException.class);
            if (ack != null) {
                String text = i18n.tr("Bitte senden Sie den INI-Brief an Ihre Bank und warten Sie auf die Freischaltung durch die Bank.");
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(text, 1));
                throw new ApplicationException(text);
            }
            InvalidPassphraseException ipe = (InvalidPassphraseException)HBCIProperties.getCause(e, InvalidPassphraseException.class);
            if (ipe != null) {
                Logger.write((Level)Level.TRACE, (String)"password for key file seems to be wrong", (Throwable)e);
                String text = i18n.tr("Das Passwort f\u00fcr die Schl\u00fcsseldatei ist falsch.");
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(text, 1));
                throw new ApplicationException(text);
            }
            Logger.error((String)("unable to load " + this.getPassportType() + " key"), (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Laden des Schl\u00fcssels: {0}", e.getMessage()), (Throwable)e);
        }
        finally {
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(null);
            }
        }
    }
}

