/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh.keyformat;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCICallbackSWT;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.passports.rdh.keyformat.AbstractSizRdhFormat;
import de.willuhn.jameica.hbci.passports.rdh.rmi.RDHKey;
import de.willuhn.jameica.hbci.passports.rdh.server.PassportHandleImpl;
import de.willuhn.jameica.hbci.passports.rdh.server.RDHKeyImpl;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.rmi.RemoteException;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class SizRdhDirectFormat
extends AbstractSizRdhFormat {
    @Override
    public String getName() {
        return i18n.tr("SizRDH-Format, parallele Nutzung");
    }

    @Override
    public RDHKey importKey(File file) throws ApplicationException, OperationCanceledException {
        if (file == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"));
        }
        if (!file.canRead() || !file.isFile()) {
            throw new ApplicationException(i18n.tr("Schl\u00fcsseldatei nicht lesbar"));
        }
        try {
            RDHKeyImpl key = new RDHKeyImpl(file);
            key.setFormat(this);
            return key;
        }
        catch (RemoteException re) {
            Logger.error((String)("unable to import key " + file.getAbsolutePath()), (Throwable)re);
            throw new ApplicationException(i18n.tr("Schl\u00fcsseldatei kann nicht importiert werden: {0}", re.getMessage()));
        }
    }

    @Override
    public HBCIPassport load(RDHKey key) throws ApplicationException, OperationCanceledException {
        HBCICallback callback = null;
        try {
            String filename = key.getFilename();
            Logger.error((String)("load key " + filename));
            HBCI plugin = (HBCI)Application.getPluginLoader().getPlugin(HBCI.class);
            callback = plugin.getHBCICallback();
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(new PassportHandleImpl());
            }
            HBCIUtils.setParam((String)"client.passport.SIZRDHFile.filename", (String)filename);
            HBCIUtils.setParam((String)"client.passport.SIZRDHFile.libname", (String)SizRdhDirectFormat.getRDHLib());
            HBCIUtils.setParam((String)"client.passport.SIZRDHFile.init", (String)"1");
            HBCIPassport hBCIPassport = AbstractHBCIPassport.getInstance((String)"SIZRDHFile");
            return hBCIPassport;
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            OperationCanceledException oce = (OperationCanceledException)HBCIProperties.getCause(e, OperationCanceledException.class);
            if (oce != null) {
                throw oce;
            }
            ApplicationException ae = (ApplicationException)HBCIProperties.getCause(e, ApplicationException.class);
            if (ae != null) {
                throw ae;
            }
            Logger.error((String)"unable to load key", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Laden des Schl\u00fcssels: {0}", e.getMessage()));
        }
        finally {
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(null);
            }
        }
    }
}

