/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh.keyformat;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCICallbackSWT;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.passports.rdh.keyformat.AbstractSizRdhFormat;
import de.willuhn.jameica.hbci.passports.rdh.keyformat.HBCI4JavaFormat;
import de.willuhn.jameica.hbci.passports.rdh.rmi.RDHKey;
import de.willuhn.jameica.hbci.passports.rdh.server.PassportHandleImpl;
import de.willuhn.jameica.hbci.passports.rdh.server.RDHKeyImpl;
import de.willuhn.jameica.plugin.PluginResources;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.HBCIPassportRDHNew;

public class SizRdhFormat
extends AbstractSizRdhFormat {
    @Override
    public String getName() {
        return i18n.tr("SizRDH-Format, Import und Konvertierung in Hibiscus-Format");
    }

    @Override
    public RDHKey importKey(File file) throws ApplicationException, OperationCanceledException {
        if (file == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie eine Schl\u00fcsseldatei aus"));
        }
        if (!file.canRead() || !file.isFile()) {
            throw new ApplicationException(i18n.tr("Schl\u00fcsseldatei nicht lesbar"));
        }
        HBCI plugin = (HBCI)Application.getPluginLoader().getPlugin(HBCI.class);
        PluginResources res = plugin.getResources();
        FileDialog dialog = new FileDialog(GUI.getShell(), 8192);
        dialog.setText(Application.getI18n().tr("Bitte w\u00e4hlen einen Pfad und Dateinamen, an dem der importierte Schl\u00fcssel gespeichert werden soll."));
        dialog.setFileName("hibiscus-" + file.getName());
        dialog.setOverwrite(true);
        dialog.setFilterPath(res.getWorkPath());
        String newFile = dialog.open();
        if (newFile == null || newFile.length() == 0) {
            throw new ApplicationException(i18n.tr("Keine Datei ausgew\u00e4hlt"));
        }
        File newKey = new File(newFile);
        if (!newKey.getParentFile().canWrite()) {
            throw new ApplicationException(i18n.tr("Keine Schreibberechtigung"));
        }
        Settings settings = res.getSettings();
        HBCICallback callback = plugin.getHBCICallback();
        try {
            Logger.info((String)"loading sizrdh key");
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(new PassportHandleImpl());
            }
            settings.setAttribute("hbcicallback.askpassphrase.force", true);
            HBCIUtils.setParam((String)"client.passport.SIZRDHFile.filename", (String)file.getAbsolutePath());
            HBCIUtils.setParam((String)"client.passport.SIZRDHFile.libname", (String)SizRdhFormat.getRDHLib());
            HBCIUtils.setParam((String)"client.passport.SIZRDHFile.init", (String)"0");
            HBCIPassportInternal source = (HBCIPassportInternal)AbstractHBCIPassport.getInstance((String)"SIZRDHFile");
            Logger.info((String)"converting into hbci4java format");
            HBCIUtils.setParam((String)"client.passport.default", (String)"RDHNew");
            HBCIUtils.setParam((String)"client.passport.RDHNew.filename", (String)newKey.getAbsolutePath());
            HBCIUtils.setParam((String)"client.passport.RDHNew.init", (String)"0");
            HBCIPassportInternal target = (HBCIPassportInternal)AbstractHBCIPassport.getInstance((String)"RDHNew");
            target.setCountry(source.getCountry());
            target.setBLZ(source.getBLZ());
            target.setHost(source.getHost());
            target.setPort(source.getPort());
            target.setUserId(source.getUserId());
            target.setCustomerId(source.getCustomerId());
            target.setSysId(source.getSysId());
            target.setSigId(source.getSigId());
            target.setHBCIVersion(source.getHBCIVersion());
            target.setBPD(source.getBPD());
            target.setUPD(source.getUPD());
            ((HBCIPassportRDHNew)target).setInstSigKey(source.getInstSigKey());
            ((HBCIPassportRDHNew)target).setInstEncKey(source.getInstEncKey());
            ((HBCIPassportRDHNew)target).setMyPublicSigKey(source.getMyPublicSigKey());
            ((HBCIPassportRDHNew)target).setMyPrivateSigKey(source.getMyPrivateSigKey());
            ((HBCIPassportRDHNew)target).setMyPublicEncKey(source.getMyPublicEncKey());
            ((HBCIPassportRDHNew)target).setMyPrivateEncKey(source.getMyPrivateEncKey());
            target.saveChanges();
            target.close();
            source.close();
            RDHKeyImpl key = new RDHKeyImpl(newKey);
            key.setFormat(new HBCI4JavaFormat());
            RDHKeyImpl rDHKeyImpl = key;
            return rDHKeyImpl;
        }
        catch (OperationCanceledException | ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            OperationCanceledException oce = (OperationCanceledException)HBCIProperties.getCause(e, OperationCanceledException.class);
            if (oce != null) {
                throw oce;
            }
            ApplicationException ae = (ApplicationException)HBCIProperties.getCause(e, ApplicationException.class);
            if (ae != null) {
                throw ae;
            }
            Logger.error((String)("unable to import key " + file.getAbsolutePath()), (Throwable)e);
            throw new ApplicationException(i18n.tr("Schl\u00fcsseldatei kann nicht importiert werden: {0}", e.getMessage()));
        }
        finally {
            settings.setAttribute("hbcicallback.askpassphrase.force", false);
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(null);
            }
        }
    }

    @Override
    public HBCIPassport load(RDHKey key) throws ApplicationException, OperationCanceledException {
        Logger.warn((String)"SUSPECT - key should have hbci4java format");
        return new HBCI4JavaFormat().load(key);
    }
}

