/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCICallbackSWT;
import de.willuhn.jameica.hbci.gui.DialogFactory;
import de.willuhn.jameica.hbci.gui.action.PassportProcessCode3072;
import de.willuhn.jameica.hbci.passport.PassportHandle;
import de.willuhn.jameica.hbci.passports.rdh.InsertKeyDialog;
import de.willuhn.jameica.hbci.passports.rdh.KeyPasswordSaveDialog;
import de.willuhn.jameica.hbci.passports.rdh.RDHKeyFactory;
import de.willuhn.jameica.hbci.passports.rdh.SelectSizEntryDialog;
import de.willuhn.jameica.hbci.passports.rdh.rmi.RDHKey;
import de.willuhn.jameica.hbci.passports.rdh.server.PassportImpl;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;

public class PassportHandleImpl
extends UnicastRemoteObject
implements PassportHandle {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private PassportImpl passport = null;
    private HBCIPassport hbciPassport = null;
    private HBCIHandler handler = null;
    private RDHKey key = null;

    protected PassportHandleImpl(PassportImpl passport) throws RemoteException {
        this.passport = passport;
    }

    public PassportHandleImpl(RDHKey key) throws RemoteException {
        this.key = key;
    }

    public PassportHandleImpl() throws RemoteException {
    }

    @Override
    public HBCIHandler open() throws RemoteException, ApplicationException {
        if (this.isOpen()) {
            return this.handler;
        }
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        Logger.info((String)"open rdh passport");
        try {
            InsertKeyDialog kd;
            Boolean b;
            RDHKey activeKey;
            RDHKey rDHKey = this.key != null ? this.key : (activeKey = RDHKeyFactory.findByKonto(this.passport != null ? this.passport.getKonto() : null));
            if (activeKey == null) {
                throw new ApplicationException(i18n.tr("Keine Schl\u00fcsseldatei f\u00fcr dieses Konto definiert"));
            }
            String filename = activeKey.getFilename();
            File f = new File(filename);
            if (!(f.exists() || (b = (Boolean)(kd = new InsertKeyDialog(f)).open()) != null && b.booleanValue())) {
                throw new OperationCanceledException(i18n.tr("Schl\u00fcsseldatei nicht eingelegt oder nicht lesbar"));
            }
            Logger.info((String)("using passport file " + filename));
            String hbciVersion = activeKey.getHBCIVersion();
            if (hbciVersion == null) {
                QueryMessage msg = new QueryMessage((Object)this.passport);
                Application.getMessagingFactory().getMessagingQueue("hibiscus.passport.rdh.hbciversion").sendSyncMessage((Message)msg);
                Object data = msg.getData();
                if (data == null || !(data instanceof String)) {
                    throw new ApplicationException(i18n.tr("HBCI-Version nicht ermittelbar"));
                }
                hbciVersion = (String)msg.getData();
                if (hbciVersion != null) {
                    Logger.info((String)("storing hbci [" + hbciVersion + "] version for key " + filename));
                    activeKey.setHBCIVersion(hbciVersion);
                }
            }
            this.hbciPassport = activeKey.load();
            ((AbstractHBCIPassport)this.hbciPassport).setPersistentData("hibiscus.context.config", (Object)activeKey);
            Logger.info((String)("using HBCI version " + hbciVersion));
            this.handler = new HBCIHandler(hbciVersion, this.hbciPassport);
            return this.handler;
        }
        catch (OperationCanceledException | ApplicationException | RemoteException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            Logger.error((String)"error while opening key", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim \u00d6ffnen des Schl\u00fcssels: {0}", e.getMessage()));
        }
    }

    @Override
    public void close() throws RemoteException {
        if (this.hbciPassport == null && this.handler == null) {
            return;
        }
        try {
            this.handleCode3072();
        }
        finally {
            try {
                Logger.info((String)"closing rdh passport");
                this.handler.close();
            }
            catch (Exception plugin) {}
            this.hbciPassport = null;
            this.handler = null;
            AbstractPlugin plugin = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
            HBCICallback callback = ((HBCI)plugin).getHBCICallback();
            if (callback != null && callback instanceof HBCICallbackSWT) {
                ((HBCICallbackSWT)callback).setCurrentHandle(null);
            }
            Logger.info((String)"rdh passport closed");
        }
    }

    private void handleCode3072() {
        if (this.hbciPassport == null) {
            return;
        }
        try {
            new PassportProcessCode3072().handleAction(this.hbciPassport);
        }
        catch (Exception e) {
            Logger.error((String)"error while applying new user-/customer data", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim \u00dcbernehmen der ge\u00e4nderten Zugangsdaten: {0}", e.getMessage()), 1));
        }
    }

    @Override
    public boolean isOpen() throws RemoteException {
        return this.handler != null && this.hbciPassport != null;
    }

    @Override
    public Konto[] getKonten() throws RemoteException, ApplicationException {
        Logger.info((String)"reading accounts from rdh passport");
        this.open();
        org.kapott.hbci.structures.Konto[] konten = this.hbciPassport.getAccounts();
        if (konten == null || konten.length == 0) {
            Logger.info((String)"no accounts found");
            Konto[] kontoArray = new Konto[]{};
            return kontoArray;
        }
        ArrayList<Konto> result = new ArrayList<Konto>();
        Konto k = null;
        int i = 0;
        while (i < konten.length) {
            k = Converter.HBCIKonto2HibiscusKonto(konten[i], PassportImpl.class);
            Logger.debug((String)("found account " + k.getKontonummer()));
            result.add(k);
            ++i;
        }
        Konto[] kontoArray = result.toArray(new Konto[0]);
        return kontoArray;
        finally {
            try {
                this.close();
            }
            catch (RemoteException remoteException) {}
        }
    }

    @Override
    public boolean callback(HBCIPassport p, int reason, String msg, int datatype, StringBuffer retData) throws Exception {
        switch (reason) {
            case 23: {
                SelectSizEntryDialog e = new SelectSizEntryDialog(1, retData.toString());
                retData.replace(0, retData.length(), (String)e.open());
                return true;
            }
            case 21: {
                retData.replace(0, retData.length(), DialogFactory.getKeyPassword(p));
                return true;
            }
            case 22: {
                KeyPasswordSaveDialog dialog = new KeyPasswordSaveDialog(1, p);
                String password = (String)dialog.open();
                retData.replace(0, retData.length(), password);
                return true;
            }
        }
        return false;
    }
}

