/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.passports.rdh.server;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.passports.rdh.Detail;
import de.willuhn.jameica.hbci.passports.rdh.RDHKeyFactory;
import de.willuhn.jameica.hbci.passports.rdh.keyformat.HBCI4JavaFormat;
import de.willuhn.jameica.hbci.passports.rdh.keyformat.KeyFormat;
import de.willuhn.jameica.hbci.passports.rdh.rmi.RDHKey;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.MultipleClassLoader;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.kapott.hbci.passport.HBCIPassport;

public class RDHKeyImpl
implements RDHKey {
    private File file = null;
    private de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(RDHKey.class);

    public RDHKeyImpl(File file) throws RemoteException {
        this.file = file;
    }

    public Object getAttribute(String attribute) throws RemoteException {
        if ("file".equals(attribute)) {
            return this.getFilename();
        }
        if ("enabled".equals(attribute)) {
            return this.isEnabled();
        }
        if ("alias".equals(attribute)) {
            return this.getAlias();
        }
        if ("format".equals(attribute)) {
            return this.getFormat().getName();
        }
        return null;
    }

    @Override
    public String getDescription() {
        try {
            String name = this.getAlias();
            if (name != null && name.length() > 0) {
                return name;
            }
            return this.getFilename();
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine name", (Throwable)e);
            return this.file.getAbsolutePath();
        }
    }

    @Override
    public Class getConfigDialog() throws RemoteException {
        return Detail.class;
    }

    @Override
    public void delete() throws ApplicationException {
        RDHKeyFactory.removeKey(this);
    }

    public String[] getAttributeNames() throws RemoteException {
        return new String[]{"file", "enabled", "hbciversion", "alias", "shared"};
    }

    public String getID() throws RemoteException {
        return this.getFilename();
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "file";
    }

    public boolean equals(GenericObject other) throws RemoteException {
        if (other == null) {
            return false;
        }
        return this.getID().equals(other.getID());
    }

    @Override
    public String getFilename() throws RemoteException {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getHBCIVersion() throws RemoteException {
        return this.settings.getString(String.valueOf(this.getID()) + ".hbciversion", null);
    }

    @Override
    public void setHBCIVersion(String version) throws RemoteException {
        this.settings.setAttribute(String.valueOf(this.getID()) + ".hbciversion", version);
    }

    @Override
    public boolean isEnabled() throws RemoteException {
        return this.settings.getBoolean(String.valueOf(this.getID()) + ".enabled", true);
    }

    @Override
    public void setEnabled(boolean enabled) throws RemoteException {
        this.settings.setAttribute(String.valueOf(this.getID()) + ".enabled", enabled);
    }

    @Override
    public void setFilename(String filename) throws RemoteException {
        this.file = new File(filename);
    }

    @Override
    public String getAlias() throws RemoteException {
        return this.settings.getString(String.valueOf(this.getID()) + ".alias", null);
    }

    @Override
    public void setAlias(String alias) throws RemoteException {
        this.settings.setAttribute(String.valueOf(this.getID()) + ".alias", alias);
    }

    @Override
    public Konto[] getKonten() throws RemoteException {
        String[] ids = this.settings.getList(String.valueOf(this.getID()) + ".konto", null);
        if (ids == null || ids.length == 0) {
            return null;
        }
        ArrayList<DBObject> konten = new ArrayList<DBObject>();
        int i = 0;
        while (i < ids.length) {
            try {
                konten.add(Settings.getDBService().createObject(Konto.class, ids[i]));
            }
            catch (ObjectNotFoundException noe) {
                Logger.warn((String)("konto " + ids[i] + " does not exist, skipping"));
            }
            ++i;
        }
        return konten.toArray(new Konto[0]);
    }

    @Override
    public void setKonten(Konto[] k) throws RemoteException {
        if (k == null || k.length == 0) {
            this.settings.setAttribute(String.valueOf(this.getID()) + ".konto", null);
            return;
        }
        String[] ids = new String[k.length];
        int i = 0;
        while (i < k.length) {
            ids[i] = k[i].getID();
            ++i;
        }
        this.settings.setAttribute(String.valueOf(this.getID()) + ".konto", ids);
    }

    @Override
    public HBCIPassport load() throws RemoteException, ApplicationException, OperationCanceledException {
        return this.getFormat().load(this);
    }

    private KeyFormat getFormat() throws RemoteException {
        try {
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            MultipleClassLoader loader = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader();
            String s = this.settings.getString(String.valueOf(this.getID()) + ".format", HBCI4JavaFormat.class.getName());
            Class c = loader.load(s);
            return (KeyFormat)service.get(c);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RemoteException("unable to load key format", e);
        }
    }

    public void setFormat(KeyFormat format) throws RemoteException {
        this.settings.setAttribute(String.valueOf(this.getID()) + ".format", format.getClass().getName());
    }
}

