/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.reminder;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.DBReminder;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.reminder.AbstractReminderStorageProvider;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.system.JameicaException;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class ReminderStorageProviderHibiscus
extends AbstractReminderStorageProvider {
    public Reminder get(String uuid) throws Exception {
        DBReminder r = this.getDBReminder(uuid);
        return r != null ? r.getReminder() : null;
    }

    public String add(Reminder reminder) throws Exception {
        if (reminder == null) {
            throw new JameicaException("no reminder given");
        }
        String uuid = this.createUUID();
        DBReminder r = (DBReminder)Settings.getDBService().createObject(DBReminder.class, null);
        r.setUUID(uuid);
        r.setReminder(reminder);
        r.store();
        return uuid;
    }

    public void update(String uuid, Reminder reminder) throws Exception {
        if (StringUtils.trimToNull((String)uuid) == null) {
            throw new JameicaException("no uuid given");
        }
        if (reminder == null) {
            throw new JameicaException("no reminder given");
        }
        DBReminder r = this.getDBReminder(uuid);
        if (r == null) {
            throw new ObjectNotFoundException("no reminder found for uuid: " + uuid);
        }
        r.setReminder(reminder);
        r.store();
    }

    public Reminder delete(String uuid) throws Exception {
        if (StringUtils.trimToNull((String)uuid) == null) {
            throw new JameicaException("no uuid given");
        }
        DBReminder r = this.getDBReminder(uuid);
        if (r == null) {
            return null;
        }
        Reminder reminder = r.getReminder();
        r.delete();
        return reminder;
    }

    public String[] getUUIDs() throws Exception {
        return (String[])Settings.getDBService().execute("select uuid from reminder", null, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                return list.toArray(new String[0]);
            }
        });
    }

    private DBReminder getDBReminder(String uuid) throws Exception {
        if (StringUtils.trimToNull((String)uuid) == null) {
            throw new JameicaException("no uuid given");
        }
        HBCIDBService service = Settings.getDBService();
        DBIterator i = service.createList(DBReminder.class);
        i.addFilter("uuid = ?", new Object[]{uuid});
        if (i.hasNext()) {
            return (DBReminder)i.next();
        }
        return null;
    }
}

