/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.reminder;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.reminder.ReminderStorageProviderHibiscus;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class ReminderUtil {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public static void apply(HibiscusDBObject order, ReminderInterval interval, Date end) throws Exception {
        if (!(order instanceof Terminable)) {
            Logger.info((String)("type " + order.getClass().getName() + " does not support reminders"));
            throw new ApplicationException(i18n.tr("Der Auftrag unterst\u00fctzt keine Termine"));
        }
        try {
            Reminder reminder;
            order.transactionBegin();
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            ReminderStorageProvider provider = (ReminderStorageProvider)service.get(ReminderStorageProviderHibiscus.class);
            MetaKey UUID2 = MetaKey.REMINDER_UUID;
            String uuid = UUID2.get(order);
            Reminder reminder2 = reminder = uuid != null ? provider.get(uuid) : null;
            if (interval == null) {
                if (reminder != null) {
                    provider.delete(uuid);
                    UUID2.set(order, null);
                }
            } else {
                List dates;
                if (reminder == null) {
                    reminder = new Reminder();
                }
                if ((dates = interval.getDates(((Terminable)((Object)order)).getTermin(), null, null)).size() < 2) {
                    throw new ApplicationException(i18n.tr("Kein Datum f\u00fcr die n\u00e4chste Wiederholung ermittelbar"));
                }
                reminder.setDate((Date)dates.get(1));
                reminder.setEnd(DateUtil.endOfDay((Date)end));
                reminder.setData("jameica.reminder.key.expired", null);
                reminder.setQueue("hibiscus.reminder.order");
                reminder.setData("order.class", (Serializable)((Object)order.getClass().getName()));
                reminder.setData("order.id", (Serializable)((Object)order.getID()));
                reminder.setReminderInterval(interval);
                if (uuid != null) {
                    provider.update(uuid, reminder);
                } else {
                    uuid = provider.add(reminder);
                    UUID2.set(order, uuid);
                }
            }
            order.transactionCommit();
        }
        catch (Exception e) {
            try {
                order.transactionRollback();
            }
            catch (Exception e2) {
                Logger.error((String)"unable to rollback transaction", (Throwable)e2);
            }
            throw e;
        }
    }
}

