/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.report.balance;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.report.balance.AccountBalanceProvider;
import de.willuhn.jameica.hbci.report.balance.BookingAccountBalanceProvider;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class AccountBalanceService {
    private List<AccountBalanceProvider> providers = null;
    private static final Class<? extends AccountBalanceProvider> DEFAULT = BookingAccountBalanceProvider.class;

    public synchronized List<AccountBalanceProvider> getProviders() {
        if (this.providers != null) {
            return this.providers;
        }
        this.providers = new LinkedList<AccountBalanceProvider>();
        try {
            Class[] found;
            Logger.info((String)"loading account balance providers");
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            Class[] classArray = found = Application.getPluginLoader().getPlugin(HBCI.class).getManifest().getClassLoader().getClassFinder().findImplementors(AccountBalanceProvider.class);
            int n = found.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    Logger.debug((String)("  " + c.getName()));
                    this.providers.add((AccountBalanceProvider)service.get(c));
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load account balance provider " + c.getName() + ", skipping"), (Throwable)e);
                }
                ++n2;
            }
            Logger.info((String)("  found " + this.providers.size() + " provider(s)"));
            Collections.sort(this.providers, new Comparator<AccountBalanceProvider>(){

                @Override
                public int compare(AccountBalanceProvider o1, AccountBalanceProvider o2) {
                    if (DEFAULT.isInstance(o1)) {
                        return 1;
                    }
                    if (DEFAULT.isInstance(o2)) {
                        return -1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        catch (ClassNotFoundException e) {
            Logger.warn((String)"no account balance providers found");
        }
        catch (Exception e) {
            Logger.error((String)"error while searching for account balance providers", (Throwable)e);
        }
        return this.providers;
    }

    public AccountBalanceProvider getBalanceProviderForAccount(Konto konto) {
        for (AccountBalanceProvider provider : this.getProviders()) {
            if (!provider.supports(konto)) continue;
            return provider;
        }
        return null;
    }
}

