/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.report.balance;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.gui.chart.AbstractChartDataSaldo;
import de.willuhn.jameica.hbci.gui.chart.ChartDataSaldoVerlauf;
import de.willuhn.jameica.hbci.report.balance.AccountBalanceProvider;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.hbci.server.Value;
import de.willuhn.jameica.hbci.util.SaldoFinder;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class BookingAccountBalanceProvider
implements AccountBalanceProvider {
    @Override
    public boolean supports(Konto konto) {
        return true;
    }

    @Override
    public AbstractChartDataSaldo getBalanceChartData(Konto konto, Date start, Date end) {
        List<Value> data = this.getBalanceData(konto, start, end);
        return new ChartDataSaldoVerlauf(konto, data);
    }

    @Override
    public List<Value> getBalanceData(Konto konto, Date start, Date end) {
        start = DateUtil.startOfDay((Date)(start == null ? new Date() : start));
        end = DateUtil.endOfDay((Date)(end == null ? new Date() : end));
        ArrayList<Value> data = new ArrayList<Value>();
        try {
            DBIterator list = UmsatzUtil.getUmsaetze();
            if (konto != null) {
                list.addFilter("konto_id = " + konto.getID());
            }
            list.addFilter("datum >= ?", new Object[]{new java.sql.Date(start.getTime())});
            list.addFilter("datum <= ?", new Object[]{new java.sql.Date(end.getTime())});
            double startSaldo = 0.0;
            if (konto != null) {
                startSaldo = konto.getNumUmsaetze() > 0 ? KontoUtil.getAnfangsSaldo(konto, start) : konto.getSaldo();
            }
            SaldoFinder finder = new SaldoFinder((GenericIterator)list, startSaldo);
            Date localStart = start;
            Calendar cal = Calendar.getInstance();
            cal.setTime(start);
            while (!localStart.after(end)) {
                Value s = new Value(localStart, finder.get(localStart));
                data.add(s);
                cal.add(5, 1);
                localStart = cal.getTime();
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"Fehler beim der Ermittlung der Salden", (Throwable)e);
        }
        return data;
    }

    @Override
    public String getName() {
        return "BookingAccountBalanceProvider";
    }
}

