/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.rmi;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;

public enum BatchBookType {
    NONE(null, "", "nach Vorgabewert der Bank ausweisen (Standard)"),
    TRUE(Boolean.TRUE, "1", "als Sammelbuchung ausweisen"),
    FALSE(Boolean.FALSE, "0", "als Einzelbuchungen ausweisen (erfordert ggf. Bankvereinbarung)");

    public static BatchBookType DEFAULT;
    private Boolean bv = null;
    private String value = null;
    private String description = null;

    static {
        DEFAULT = NONE;
    }

    private BatchBookType(Boolean bv, String value, String description) {
        this.bv = bv;
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public Boolean getBooleanValue() {
        return this.bv;
    }

    public String getDescription() {
        return this.description;
    }

    public static BatchBookType byValue(String value) {
        if (value != null) {
            BatchBookType[] batchBookTypeArray = BatchBookType.values();
            int n = batchBookTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                BatchBookType type = batchBookTypeArray[n2];
                if (value.equals(type.value)) {
                    return type;
                }
                ++n2;
            }
        }
        return null;
    }

    public static BatchBookType byXmlValue(String value) {
        if (value == null) {
            return NONE;
        }
        BatchBookType t = BatchBookType.byValue(Boolean.valueOf(value));
        return t != null ? t : NONE;
    }

    public static BatchBookType byValue(Boolean value) {
        BatchBookType[] batchBookTypeArray = BatchBookType.values();
        int n = batchBookTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BatchBookType type = batchBookTypeArray[n2];
            if (value == type.bv) {
                return type;
            }
            if (value != null && value.equals(type.bv)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        return String.valueOf(this.name()) + ": " + i18n.tr(this.getDescription());
    }
}

