/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.rmi;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;

public enum KontoType {
    GIRO(1, 9, "Kontokorrent-/Girokonto"),
    SPAR(10, 19, "Sparkonto"),
    FESTGELD(20, 29, "Festgeldkonto (Termineinlagen)"),
    WERTPAPIERDEPOT(30, 39, "Wertpapierdepot"),
    DARLEHEN(40, 49, "Kredit-/Darlehenskonto"),
    KREDITKARTE(50, 59, "Kreditkartenkonto"),
    FONDSDEPOT(60, 69, "Fonds-Depot bei einer Kapitalanlagegesellschaft"),
    BAUSPAR(70, 79, "Bausparvertrag"),
    VERSICHERUNG(80, 89, "Versicherungsvertrag"),
    SONSTIGE(90, 99, "Sonstige (nicht zuordenbar)");

    private static final I18N i18n;
    public static final KontoType DEFAULT;
    private int min;
    private int max;
    private String name;

    static {
        i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        DEFAULT = GIRO;
    }

    private KontoType(int min, int max, String name) {
        this.min = min;
        this.max = max;
        this.name = name;
    }

    public String getName() {
        return i18n.tr(this.name);
    }

    public int getValue() {
        return this.min;
    }

    public static KontoType find(Integer id) {
        if (id == null) {
            return null;
        }
        int i = id;
        KontoType[] kontoTypeArray = KontoType.values();
        int n = kontoTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KontoType type = kontoTypeArray[n2];
            if (i >= type.min && i <= type.max) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

