/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.rmi;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class KontoauszugInterval {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    public static KontoauszugInterval DEFAULT = new IntervalNever();
    public static final List<KontoauszugInterval> KNOWN = Arrays.asList(new IntervalNever(), new IntervalAlways(), new IntervalWeekly(), new IntervalBiWeekly(), new IntervalMonthly());

    public static Date getNextInterval(Konto k) throws RemoteException {
        KontoauszugInterval type = KontoauszugInterval.find(MetaKey.KONTOAUSZUG_INTERVAL.get(k));
        if (type == null) {
            return null;
        }
        Date last = null;
        String s = null;
        try {
            s = MetaKey.KONTOAUSZUG_INTERVAL_LAST.get(k);
            if (s != null && s.length() > 0) {
                last = HBCI.LONGDATEFORMAT.parse(s);
            }
        }
        catch (Exception e) {
            Logger.error((String)("unparsable date: " + s), (Throwable)e);
        }
        return type.getNextInterval(last);
    }

    public static KontoauszugInterval find(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        for (KontoauszugInterval k : KNOWN) {
            if (!k.getId().equals(id)) continue;
            return k;
        }
        return null;
    }

    public abstract Date getNextInterval(Date var1);

    public abstract String getId();

    public abstract String getName();

    public static class IntervalAlways
    extends KontoauszugInterval {
        @Override
        public Date getNextInterval(Date last) {
            return DateUtil.startOfDay((Date)new Date());
        }

        @Override
        public String getId() {
            return "always";
        }

        @Override
        public String getName() {
            return i18n.tr("immer");
        }
    }

    public static class IntervalBiWeekly
    extends KontoauszugInterval {
        @Override
        public Date getNextInterval(Date last) {
            if (last == null) {
                return DateUtil.startOfDay((Date)new Date());
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(last);
            cal.add(5, 14);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public String getId() {
            return "biweekly";
        }

        @Override
        public String getName() {
            return i18n.tr("Alle 2 Wochen");
        }
    }

    public static class IntervalMonthly
    extends KontoauszugInterval {
        @Override
        public Date getNextInterval(Date last) {
            if (last == null) {
                return DateUtil.startOfDay((Date)new Date());
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(last);
            cal.add(2, 1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public String getId() {
            return "monthly";
        }

        @Override
        public String getName() {
            return i18n.tr("Monatlich");
        }
    }

    public static class IntervalNever
    extends KontoauszugInterval {
        @Override
        public Date getNextInterval(Date last) {
            return null;
        }

        @Override
        public String getId() {
            return "never";
        }

        @Override
        public String getName() {
            return i18n.tr("Nie (nur manuell)");
        }
    }

    public static class IntervalWeekly
    extends KontoauszugInterval {
        @Override
        public Date getNextInterval(Date last) {
            if (last == null) {
                return DateUtil.startOfDay((Date)new Date());
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(last);
            cal.add(5, 7);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public String getId() {
            return "weekly";
        }

        @Override
        public String getName() {
            return i18n.tr("W\u00f6chentlich");
        }
    }
}

