/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.rmi;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public enum PurposeCode {
    RENT("RENT", "Miete"),
    DEPT("DEPT", "Einzahlung"),
    REFU("REFU", "Gutschrift/R\u00fcck\u00fcberweisung"),
    SALA("SALA", "Gehaltszahlungen"),
    PAYR("PAYR", "Lohn"),
    SSBE("SSBE", "Sozialleistung"),
    GOVT("GOVT", "Zahlung an \u00f6ffentl. Kassen"),
    CBFF("CBFF", "Verm\u00f6genswirksame Leistungen"),
    BONU("BONU", "Bonuszahlungen"),
    CHAR("CHAR", "Spendenzahlungen"),
    RINP("RINP", "Wiederkehrende Zahlungen / Dauerauftrag"),
    CASH("CASH", "Cash Management Transfer"),
    NOWS("NOWS", "Nicht n\u00e4her definiert"),
    OTHR("OTHR", "Andere");

    private static final I18N i18n;
    private String code;
    private String name;

    static {
        i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    }

    private PurposeCode(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return i18n.tr(this.name);
    }

    public static PurposeCode find(String code) {
        if (StringUtils.trimToNull((String)code) == null) {
            return null;
        }
        PurposeCode[] purposeCodeArray = PurposeCode.values();
        int n = purposeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PurposeCode pc = purposeCodeArray[n2];
            if (pc.getCode().equals(code)) {
                return pc;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public static List<String> codes() {
        ArrayList<String> result = new ArrayList<String>();
        PurposeCode[] purposeCodeArray = PurposeCode.values();
        int n = purposeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PurposeCode c = purposeCodeArray[n2];
            result.add(c.getCode());
            ++n2;
        }
        return result;
    }
}

