/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.schedule;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.reminder.ReminderStorageProviderHibiscus;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.jameica.hbci.schedule.ScheduleProvider;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

@Lifecycle(value=Lifecycle.Type.REQUEST)
public abstract class AbstractTransferScheduleProvider<T extends Terminable & HibiscusDBObject>
implements ScheduleProvider<T> {
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private DBIterator list = null;

    @Override
    public List<Schedule<T>> getSchedules(Konto k, Date from, Date to) {
        LinkedList<Schedule<T>> result = new LinkedList<Schedule<T>>();
        Class type = BeanUtil.getType(this.getClass());
        if (type == null) {
            Logger.warn((String)"schedule provider has no concrete type - unable to fetch data");
            return result;
        }
        try {
            BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            ReminderStorageProvider provider = (ReminderStorageProvider)bs.get(ReminderStorageProviderHibiscus.class);
            Date start = DateUtil.startOfDay((Date)from);
            Date end = DateUtil.endOfDay((Date)to);
            Date now = new Date();
            if (this.list == null) {
                HBCIDBService service = Settings.getDBService();
                this.list = service.createList(type);
                if (k != null) {
                    this.list.addFilter("konto_id = " + k.getID());
                }
                this.list.setOrder("ORDER BY " + service.getSQLTimestamp("termin"));
            }
            this.list.begin();
            while (this.list.hasNext()) {
                ReminderInterval ri;
                Terminable u = (Terminable)this.list.next();
                String uuid = MetaKey.REMINDER_UUID.get((HibiscusDBObject)((Object)u));
                Date termin = u.getTermin();
                if (!termin.before(start) && !termin.after(end)) {
                    result.add(new Schedule<HibiscusDBObject>(termin, (HibiscusDBObject)((Object)u), false));
                }
                if (termin.after(end) || uuid == null) continue;
                Reminder reminder = provider.get(uuid);
                ReminderInterval reminderInterval = ri = reminder != null ? reminder.getReminderInterval() : null;
                if (ri == null) continue;
                Date last = reminder.getEnd();
                List dates = ri.getDates(termin, new Date(termin.getTime() + 1L), end);
                for (Date date : dates) {
                    if (last != null && date.after(last) || !date.after(now)) continue;
                    result.add(new Schedule<HibiscusDBObject>(date, (HibiscusDBObject)((Object)u), true));
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to load data", (Throwable)e);
        }
        return result;
    }
}

