/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.schedule;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.schedule.ScheduleProvider;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ClassFinder;
import de.willuhn.util.MultipleClassLoader;

public class ScheduleProviderFactory {
    public static synchronized ScheduleProvider getScheduleProvider(Class<? extends HibiscusDBObject> type) {
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        MultipleClassLoader loader = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader();
        ClassFinder finder = loader.getClassFinder();
        try {
            Class[] classes;
            Class[] classArray = classes = finder.findImplementors(ScheduleProvider.class);
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    if (ScheduleProviderFactory.matches(c, type)) {
                        return (ScheduleProvider)service.get(c);
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"unable to check/load schedule provider", (Throwable)e);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            Logger.error((String)"no schedule providers found", (Throwable)e);
        }
        return null;
    }

    private static boolean matches(Class c, Class<? extends HibiscusDBObject> type) {
        Class concrete = BeanUtil.getType((Class)c);
        return concrete != null && concrete.equals(type);
    }
}

