/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.schedule;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.jameica.hbci.schedule.ScheduleProvider;
import de.willuhn.jameica.hbci.server.DauerauftragUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

@Lifecycle(value=Lifecycle.Type.REQUEST)
public class SepaDauerauftragScheduleProvider
implements ScheduleProvider<SepaDauerauftrag> {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public List<Schedule<SepaDauerauftrag>> getSchedules(Konto k, Date from, Date to) {
        LinkedList<Schedule<SepaDauerauftrag>> result = new LinkedList<Schedule<SepaDauerauftrag>>();
        try {
            HBCIDBService service = Settings.getDBService();
            DBIterator list = service.createList(SepaDauerauftrag.class);
            if (k != null) {
                list.addFilter("konto_id = " + k.getID());
            }
            while (list.hasNext()) {
                SepaDauerauftrag t = (SepaDauerauftrag)list.next();
                List<Date> termine = DauerauftragUtil.getTermine(t, from, to);
                if (termine == null || termine.size() == 0) continue;
                for (Date termin : termine) {
                    result.add(new Schedule<SepaDauerauftrag>(termin, t, false));
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to load data", (Throwable)e);
        }
        return result;
    }

    @Override
    public String getName() {
        return i18n.tr("SEPA-Dauerauftr\u00e4ge");
    }
}

