/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.schedule;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.schedule.Schedule;
import de.willuhn.jameica.hbci.schedule.ScheduleProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

@Lifecycle(value=Lifecycle.Type.REQUEST)
public class UmsatzScheduleProvider
implements ScheduleProvider<Umsatz> {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public List<Schedule<Umsatz>> getSchedules(Konto k, Date from, Date to) {
        LinkedList<Schedule<Umsatz>> result = new LinkedList<Schedule<Umsatz>>();
        try {
            HBCIDBService service = Settings.getDBService();
            DBIterator list = service.createList(Umsatz.class);
            if (k != null) {
                list.addFilter("konto_id = " + k.getID());
            }
            if (from != null) {
                list.addFilter("datum >= ?", new Object[]{new java.sql.Date(DateUtil.startOfDay((Date)from).getTime())});
            }
            if (to != null) {
                list.addFilter("datum <= ?", new Object[]{new java.sql.Date(DateUtil.endOfDay((Date)to).getTime())});
            }
            list.setOrder("ORDER BY " + service.getSQLTimestamp("datum"));
            while (list.hasNext()) {
                Umsatz u = (Umsatz)list.next();
                result.add(new Schedule<Umsatz>(u.getDatum(), u, false));
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to load data", (Throwable)e);
        }
        return result;
    }

    @Override
    public String getName() {
        return i18n.tr("Ums\u00e4tze");
    }
}

