/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.search;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.EmpfaengerNew;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.AddressbookService;
import de.willuhn.jameica.search.Result;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class AddressbookSearchProvider
implements SearchProvider {
    public String getName() {
        return Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N().tr("Adressbuch");
    }

    public List search(String search) throws RemoteException, ApplicationException {
        List result;
        block6: {
            if (search == null || search.length() == 0) {
                return null;
            }
            AddressbookService service = (AddressbookService)Application.getServiceFactory().lookup(HBCI.class, "addressbook");
            result = service.findAddresses(search);
            if (result != null) break block6;
            return null;
        }
        try {
            ArrayList<MyResult> al = new ArrayList<MyResult>();
            int i = 0;
            while (i < result.size()) {
                al.add(new MyResult((Address)result.get(i)));
                ++i;
            }
            return al;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            Logger.error((String)"unable to search in addressbook", (Throwable)e);
            return null;
        }
    }

    private class MyResult
    implements Result {
        private Address address = null;

        private MyResult(Address a) {
            this.address = a;
        }

        public void execute() throws RemoteException, ApplicationException {
            new EmpfaengerNew().handleAction(this.address);
        }

        public String getName() {
            try {
                String comment = this.address.getKommentar();
                if (comment != null && comment.length() > 0) {
                    return String.valueOf(this.address.getName()) + " (" + comment + ")";
                }
                return this.address.getName();
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determin result name", (Throwable)re);
                return null;
            }
        }
    }
}

