/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.search;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.DauerauftragNew;
import de.willuhn.jameica.hbci.rmi.Dauerauftrag;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.search.Result;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DauerauftragSearchProvider
implements SearchProvider {
    public String getName() {
        return Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N().tr("Dauerauftr\u00e4ge");
    }

    public List search(String search) throws RemoteException, ApplicationException {
        if (search == null || search.length() == 0) {
            return null;
        }
        String text = "%" + search.toLowerCase() + "%";
        HBCIDBService service = Settings.getDBService();
        DBIterator list = service.createList(Dauerauftrag.class);
        list.addFilter("LOWER(zweck) LIKE ? OR LOWER(zweck2) LIKE ? OR LOWER(zweck3) LIKE ? OR LOWER(empfaenger_name) LIKE ? OR empfaenger_konto LIKE ? OR empfaenger_blz LIKE ?", new Object[]{text, text, text, text, text, text});
        list.setOrder("ORDER BY " + service.getSQLTimestamp("erste_zahlung") + " DESC");
        ArrayList<MyResult> results = new ArrayList<MyResult>();
        while (list.hasNext()) {
            results.add(new MyResult((Dauerauftrag)list.next()));
        }
        return results;
    }

    private class MyResult
    implements Result {
        private Dauerauftrag u = null;

        private MyResult(Dauerauftrag u) {
            this.u = u;
        }

        public void execute() throws RemoteException, ApplicationException {
            new DauerauftragNew().handleAction(this.u);
        }

        public String getName() {
            try {
                Konto k = this.u.getKonto();
                String[] params = new String[]{this.u.getTurnus().getBezeichnung(), this.u.getZweck(), HBCI.DECIMALFORMAT.format(this.u.getBetrag()), k.getWaehrung(), this.u.getGegenkontoName()};
                I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
                return i18n.tr("{0}: ({1}) {2} {3} an {4}", params);
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determin result name", (Throwable)re);
                return null;
            }
        }
    }
}

