/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.search;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.KontoNew;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.search.Result;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class KontoSearchProvider
implements SearchProvider {
    public String getName() {
        return Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N().tr("Konten");
    }

    public List search(String search) throws RemoteException, ApplicationException {
        if (search == null || search.length() == 0) {
            return null;
        }
        String text = "%" + search.toLowerCase() + "%";
        DBIterator list = Settings.getDBService().createList(Konto.class);
        list.addFilter("LOWER(name) LIKE ? OR LOWER(bezeichnung) LIKE ? OR kontonummer LIKE ? OR blz LIKE ? OR kundennummer LIKE ?", new Object[]{text, text, text, text, text});
        ArrayList<MyResult> results = new ArrayList<MyResult>();
        while (list.hasNext()) {
            results.add(new MyResult((Konto)list.next()));
        }
        return results;
    }

    private class MyResult
    implements Result {
        private Konto konto = null;

        private MyResult(Konto k) {
            this.konto = k;
        }

        public void execute() throws RemoteException, ApplicationException {
            new KontoNew().handleAction(this.konto);
        }

        public String getName() {
            try {
                String bank = HBCIProperties.getNameForBank(this.konto.getBLZ());
                String bez = this.konto.getBezeichnung();
                if (bank != null && bank.length() > 0) {
                    return String.valueOf(bez) + ", " + bank;
                }
                return bez;
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determin result name", (Throwable)re);
                return null;
            }
        }
    }
}

