/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.search;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.LastschriftNew;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Lastschrift;
import de.willuhn.jameica.search.Result;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class LastschriftSearchProvider
implements SearchProvider {
    public String getName() {
        return Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N().tr("Lastschriften");
    }

    public List search(String search) throws RemoteException, ApplicationException {
        if (search == null || search.length() == 0) {
            return null;
        }
        String text = "%" + search.toLowerCase() + "%";
        HBCIDBService service = Settings.getDBService();
        DBIterator list = service.createList(Lastschrift.class);
        list.addFilter("LOWER(zweck) LIKE ? OR LOWER(zweck2) LIKE ? OR LOWER(zweck3) LIKE ? OR LOWER(empfaenger_name) LIKE ? OR empfaenger_konto LIKE ? OR empfaenger_blz LIKE ?", new Object[]{text, text, text, text, text, text});
        list.setOrder("ORDER BY " + service.getSQLTimestamp("termin") + " DESC");
        ArrayList<MyResult> results = new ArrayList<MyResult>();
        while (list.hasNext()) {
            results.add(new MyResult((Lastschrift)list.next()));
        }
        return results;
    }

    private class MyResult
    implements Result {
        private Lastschrift l = null;

        private MyResult(Lastschrift l) {
            this.l = l;
        }

        public void execute() throws RemoteException, ApplicationException {
            new LastschriftNew().handleAction(this.l);
        }

        public String getName() {
            try {
                Konto k = this.l.getKonto();
                String[] params = new String[]{HBCI.DATEFORMAT.format(this.l.getTermin()), HBCI.DECIMALFORMAT.format(this.l.getBetrag()), k.getWaehrung(), this.l.getGegenkontoName(), this.l.getZweck(), k.getLongName()};
                I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
                return i18n.tr("{0}: {1} {2} von {3} - {4} (via {5})", params);
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determin result name", (Throwable)re);
                return null;
            }
        }
    }
}

