/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.search;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.SepaDauerauftragNew;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.search.Result;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SepaDauerauftragSearchProvider
implements SearchProvider {
    public String getName() {
        return Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N().tr("SEPA-Dauerauftr\u00e4ge");
    }

    public List search(String search) throws RemoteException, ApplicationException {
        if (search == null || search.length() == 0) {
            return null;
        }
        String text = "%" + search.toLowerCase() + "%";
        HBCIDBService service = Settings.getDBService();
        DBIterator list = service.createList(SepaDauerauftrag.class);
        list.addFilter("LOWER(zweck) LIKE ? OR LOWER(empfaenger_name) LIKE ? OR LOWER(endtoendid) LIKE ? OR LOWER(empfaenger_konto) LIKE ?", new Object[]{text, text, text, text});
        list.setOrder("ORDER BY " + service.getSQLTimestamp("erste_zahlung") + " DESC");
        ArrayList<MyResult> results = new ArrayList<MyResult>();
        while (list.hasNext()) {
            results.add(new MyResult((SepaDauerauftrag)list.next()));
        }
        return results;
    }

    private class MyResult
    implements Result {
        private SepaDauerauftrag u = null;

        private MyResult(SepaDauerauftrag u) {
            this.u = u;
        }

        public void execute() throws RemoteException, ApplicationException {
            new SepaDauerauftragNew().handleAction(this.u);
        }

        public String getName() {
            try {
                Konto k = this.u.getKonto();
                String[] params = new String[]{this.u.getTurnus().getBezeichnung(), this.u.getZweck(), HBCI.DECIMALFORMAT.format(this.u.getBetrag()), k.getWaehrung(), this.u.getGegenkontoName()};
                I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
                return i18n.tr("{0}: ({1}) {2} {3} an {4}", params);
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determin result name", (Throwable)re);
                return null;
            }
        }
    }
}

