/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.search;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastschriftNew;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastBuchung;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.search.Result;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class SepaSammelLastschriftSearchProvider
implements SearchProvider {
    public String getName() {
        return Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N().tr("SEPA-Sammellastschriften");
    }

    public List search(String search) throws RemoteException, ApplicationException {
        if (search == null || search.length() == 0) {
            return null;
        }
        String text = "%" + search.toLowerCase() + "%";
        Hashtable<String, MyResult> hash = new Hashtable<String, MyResult>();
        DBIterator list = Settings.getDBService().createList(SepaSammelLastBuchung.class);
        list.addFilter("LOWER(zweck) LIKE ? OR LOWER(endtoendid) LIKE ? OR LOWER(creditorid) LIKE ? OR LOWER(mandateid) LIKE ? OR LOWER(empfaenger_name) LIKE ? OR LOWER(empfaenger_konto) LIKE ? OR LOWER(empfaenger_bic) LIKE ?", new Object[]{text, text, text, text, text, text, text});
        while (list.hasNext()) {
            SepaSammelLastBuchung buchung = (SepaSammelLastBuchung)list.next();
            SepaSammelLastschrift ueb = (SepaSammelLastschrift)buchung.getSammelTransfer();
            hash.put(ueb.getID(), new MyResult(ueb));
        }
        list = Settings.getDBService().createList(SepaSammelLastschrift.class);
        list.addFilter("LOWER(bezeichnung) LIKE ?", new Object[]{text});
        while (list.hasNext()) {
            SepaSammelLastschrift ueb = (SepaSammelLastschrift)list.next();
            hash.put(ueb.getID(), new MyResult(ueb));
        }
        return Arrays.asList(hash.values().toArray(new MyResult[0]));
    }

    private class MyResult
    implements Result {
        private SepaSammelLastschrift u = null;

        private MyResult(SepaSammelLastschrift u) {
            this.u = u;
        }

        public void execute() throws RemoteException, ApplicationException {
            new SepaSammelLastschriftNew().handleAction(this.u);
        }

        public String getName() {
            try {
                I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
                return i18n.tr("{0}: {1}", new String[]{HBCI.DATEFORMAT.format(this.u.getTermin()), this.u.getBezeichnung()});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determin result name", (Throwable)re);
                return null;
            }
        }
    }
}

