/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.search;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetail;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.search.Result;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UmsatzSearchProvider
implements SearchProvider {
    public String getName() {
        return Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N().tr("Ums\u00e4tze");
    }

    public List search(String search) throws RemoteException, ApplicationException {
        if (search == null || search.length() == 0) {
            return null;
        }
        DBIterator list = UmsatzUtil.find(search);
        ArrayList<MyResult> results = new ArrayList<MyResult>();
        while (list.hasNext()) {
            results.add(new MyResult((Umsatz)list.next()));
        }
        return results;
    }

    private class MyResult
    implements Result {
        private Umsatz umsatz = null;

        private MyResult(Umsatz u) {
            this.umsatz = u;
        }

        public void execute() throws RemoteException, ApplicationException {
            new UmsatzDetail().handleAction(this.umsatz);
        }

        public String getName() {
            try {
                I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
                Konto konto = this.umsatz.getKonto();
                Date date = this.umsatz.getDatum();
                double betrag = this.umsatz.getBetrag();
                String rel = i18n.tr(betrag > 0.0 ? "von" : "an");
                String zweck = StringUtils.trimToEmpty((String)this.umsatz.getZweck());
                String gegenkontoName = this.umsatz.getGegenkontoName();
                betrag = Math.abs(betrag);
                if (gegenkontoName == null || gegenkontoName.length() == 0) {
                    return i18n.tr("{0}: {1} {2} - {3}", new String[]{HBCI.DATEFORMAT.format(date), HBCI.DECIMALFORMAT.format(betrag), konto.getWaehrung(), zweck});
                }
                return i18n.tr("{0}: {1} {2} {3} {4} - {5}", new String[]{HBCI.DATEFORMAT.format(date), HBCI.DECIMALFORMAT.format(betrag), konto.getWaehrung(), rel, gegenkontoName, zweck});
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to determin result name", (Throwable)re);
                return null;
            }
        }
    }
}

