/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.rmi.BaseDauerauftrag;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.hbci.server.AbstractHibiscusTransferImpl;
import de.willuhn.jameica.hbci.server.TurnusHelper;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import java.util.Date;

public abstract class AbstractBaseDauerauftragImpl
extends AbstractHibiscusTransferImpl
implements BaseDauerauftrag {
    public String getPrimaryAttribute() throws RemoteException {
        return "zweck";
    }

    @Override
    public Date getErsteZahlung() throws RemoteException {
        return (Date)this.getAttribute("erste_zahlung");
    }

    @Override
    public Date getLetzteZahlung() throws RemoteException {
        return (Date)this.getAttribute("letzte_zahlung");
    }

    @Override
    public Turnus getTurnus() throws RemoteException {
        Integer ze = (Integer)this.getAttribute("zeiteinheit");
        Integer intervall = (Integer)this.getAttribute("intervall");
        Integer tag = (Integer)this.getAttribute("tag");
        if (ze == null || intervall == null || tag == null) {
            return null;
        }
        Turnus t = (Turnus)this.getService().createObject(Turnus.class, null);
        t.setIntervall(intervall);
        t.setZeiteinheit(ze);
        t.setTag(tag);
        return t;
    }

    @Override
    public boolean isActive() throws RemoteException {
        return this.getOrderID() != null && this.getOrderID().length() > 0;
    }

    @Override
    public void setErsteZahlung(Date datum) throws RemoteException {
        this.setAttribute("erste_zahlung", datum);
    }

    @Override
    public void setLetzteZahlung(Date datum) throws RemoteException {
        this.setAttribute("letzte_zahlung", datum);
    }

    @Override
    public void setTurnus(Turnus turnus) throws RemoteException {
        if (turnus == null) {
            return;
        }
        this.setAttribute("zeiteinheit", turnus.getZeiteinheit());
        this.setAttribute("intervall", turnus.getIntervall());
        this.setAttribute("tag", turnus.getTag());
    }

    public boolean equals(GenericObject o) throws RemoteException {
        if (o == null || !(o instanceof BaseDauerauftrag)) {
            return false;
        }
        try {
            BaseDauerauftrag other = (BaseDauerauftrag)o;
            String id1 = this.getID();
            String id2 = other.getID();
            if (id1 != null && id2 != null) {
                return id1.equals(id2);
            }
            return other.getChecksum() == this.getChecksum();
        }
        catch (Exception e) {
            Logger.error((String)"error while comparing objects", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getOrderID() throws RemoteException {
        return (String)this.getAttribute("orderid");
    }

    @Override
    public void setOrderID(String id) throws RemoteException {
        this.setAttribute("orderid", id);
    }

    @Override
    public Object getAttribute(String arg0) throws RemoteException {
        if ("turnus_id".equals(arg0)) {
            return this.getTurnus();
        }
        if ("naechste_zahlung".equals(arg0)) {
            return this.getNaechsteZahlung();
        }
        return super.getAttribute(arg0);
    }

    @Override
    public Date getNaechsteZahlung() throws RemoteException {
        return TurnusHelper.getNaechsteZahlung(this.getErsteZahlung(), this.getLetzteZahlung(), this.getTurnus(), new Date());
    }
}

