/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.BaseUeberweisung;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.hbci.server.AbstractHibiscusTransferImpl;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;

public abstract class AbstractBaseUeberweisungImpl
extends AbstractHibiscusTransferImpl
implements BaseUeberweisung,
Terminable {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private boolean markingExecuted = false;

    public String getPrimaryAttribute() throws RemoteException {
        return "zweck";
    }

    @Override
    protected void insertCheck() throws ApplicationException {
        try {
            super.insertCheck();
            if (this.getTermin() == null) {
                this.setTermin(new Date());
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking job", (Throwable)e);
            if (!this.markingExecuted()) {
                throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des SEPA-Auftrages."));
            }
        }
        catch (ApplicationException ae) {
            if (!this.markingExecuted()) {
                throw ae;
            }
            Logger.warn((String)ae.getMessage());
        }
    }

    @Override
    protected void updateCheck() throws ApplicationException {
        try {
            if (!this.markingExecuted() && this.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("Auftrag wurde bereits ausgef\u00fchrt und kann daher nicht mehr ge\u00e4ndert werden."));
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking transfer", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des Auftrags."));
        }
        super.updateCheck();
    }

    public void insert() throws RemoteException, ApplicationException {
        if (this.getAttribute("ausgefuehrt") == null) {
            this.setAttribute("ausgefuehrt", 0);
        }
        super.insert();
    }

    @Override
    public Date getTermin() throws RemoteException {
        return (Date)this.getAttribute("termin");
    }

    @Override
    public Date getAusfuehrungsdatum() throws RemoteException {
        return (Date)this.getAttribute("ausgefuehrt_am");
    }

    @Override
    public boolean ausgefuehrt() throws RemoteException {
        Integer i = (Integer)this.getAttribute("ausgefuehrt");
        if (i == null) {
            return false;
        }
        return i == 1;
    }

    @Override
    public void setTermin(Date termin) throws RemoteException {
        this.setAttribute("termin", termin);
    }

    @Override
    public boolean ueberfaellig() throws RemoteException {
        if (this.ausgefuehrt()) {
            return false;
        }
        Date termin = this.getTermin();
        if (termin == null) {
            return false;
        }
        return termin.before(new Date());
    }

    protected boolean markingExecuted() {
        return this.markingExecuted;
    }

    @Override
    public void setAusgefuehrt(boolean b) throws RemoteException, ApplicationException {
        try {
            this.markingExecuted = true;
            this.setAttribute("ausgefuehrt", b ? 1 : 0);
            this.setAttribute("ausgefuehrt_am", new Date());
            this.store();
            Logger.info((String)("[" + this.getTableName() + ":" + this.getID() + "] (" + BeanUtil.toString((Object)this) + ") - executed: " + b));
        }
        finally {
            this.markingExecuted = false;
        }
    }

    @Override
    public String getTextSchluessel() throws RemoteException {
        return (String)this.getAttribute("typ");
    }

    @Override
    public void setTextSchluessel(String schluessel) throws RemoteException {
        this.setAttribute("typ", schluessel);
    }
}

