/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.rmi.DBSupport;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.sql.ScriptExecutor;
import de.willuhn.util.Base64;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractDBSupportImpl
implements DBSupport {
    private static final String PREFIX_ENC = "encrypted:";
    private long lastCheck = 0L;

    @Override
    public void execute(Connection conn, File sqlScript) throws RemoteException {
        if (sqlScript == null) {
            return;
        }
        if (!(sqlScript = new File(sqlScript.getParent(), String.valueOf(this.getScriptPrefix()) + sqlScript.getName())).exists()) {
            Logger.debug((String)("file " + sqlScript + " does not exist, skipping"));
            return;
        }
        if (!sqlScript.canRead() || !sqlScript.exists()) {
            return;
        }
        Logger.info((String)("executing sql script: " + sqlScript.getAbsolutePath()));
        Reader reader = null;
        try {
            try {
                reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(sqlScript)), "iso-8859-1");
                ScriptExecutor.execute((Reader)reader, (Connection)conn);
            }
            catch (RemoteException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RemoteException("error while executing sql script " + sqlScript, e);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e3) {
                Logger.error((String)("error while closing file " + sqlScript), (Throwable)e3);
            }
        }
    }

    @Override
    public int getTransactionIsolationLevel() throws RemoteException {
        return -1;
    }

    @Override
    public void checkConnection(Connection conn) throws RemoteException {
        long newCheck = System.currentTimeMillis();
        if (newCheck - this.lastCheck < 10000L) {
            return;
        }
        Statement s = null;
        ResultSet rs = null;
        try {
            try {
                s = conn.createStatement();
                rs = s.executeQuery("select 1");
                this.lastCheck = newCheck;
            }
            catch (SQLException e) {
                String msg = e.getMessage();
                if (msg != null && msg.indexOf("\n") != -1) {
                    msg = msg.substring(0, msg.indexOf("\n"));
                }
                throw new RemoteException(msg);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                throw new RemoteException("unable to close statement/resultset", e);
            }
        }
    }

    String getEncrypted(String key) {
        String value = HBCIDBService.SETTINGS.getString(key, null);
        if (value == null) {
            return value;
        }
        boolean encrypted = value.startsWith(PREFIX_ENC);
        boolean doEncrypt = HBCIDBService.SETTINGS.getBoolean("encrypt", false);
        try {
            if (encrypted) {
                Logger.debug((String)("decrypting value for key " + key));
                value = value.substring(PREFIX_ENC.length());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Application.getSSLFactory().decrypt((InputStream)new ByteArrayInputStream(Base64.decode((String)value)), (OutputStream)bos);
                return bos.toString("UTF-8");
            }
            if (!doEncrypt) {
                return value;
            }
            Logger.info((String)("encrypting value for key " + key));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Application.getSSLFactory().encrypt((InputStream)new ByteArrayInputStream(value.getBytes("UTF-8")), (OutputStream)bos);
            HBCIDBService.SETTINGS.setAttribute(key, PREFIX_ENC + Base64.encode((byte[])bos.toByteArray()));
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("error while determining encrypted parameter", e);
        }
    }
}

