/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.db.AbstractDBObject;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.server.DBPropertyUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;

public abstract class AbstractHibiscusDBObject
extends AbstractDBObject
implements HibiscusDBObject {
    @Override
    public String getMeta(String name, String defaultValue) throws RemoteException {
        if (name == null || name.length() == 0) {
            throw new RemoteException("no name given for meta attribute");
        }
        String id = this.getID();
        if (id == null) {
            return defaultValue;
        }
        return DBPropertyUtil.get(DBPropertyUtil.Prefix.META, this.getTableName(), id, name, defaultValue);
    }

    @Override
    public void setMeta(String name, String value) throws RemoteException {
        if (name == null || name.length() == 0) {
            throw new RemoteException("no name given for meta attribute");
        }
        String id = this.getID();
        if (id == null) {
            throw new RemoteException("entity has no id");
        }
        DBPropertyUtil.set(DBPropertyUtil.Prefix.META, this.getTableName(), id, name, value);
    }

    public void delete() throws RemoteException, ApplicationException {
        if (this.isNewObject()) {
            return;
        }
        this.transactionBegin();
        try {
            Application.getMessagingFactory().getMessagingQueue("hibiscus.dbobject.delete").sendSyncMessage((Message)new QueryMessage((Object)this));
            DBPropertyUtil.delete(DBPropertyUtil.Prefix.META, this.getTableName(), this.getID());
            super.delete();
            this.transactionCommit();
        }
        catch (ApplicationException | RemoteException e) {
            this.transactionRollback();
            throw e;
        }
    }

    public void store() throws RemoteException, ApplicationException {
        super.store();
        Application.getMessagingFactory().getMessagingQueue("hibiscus.dbobject.store").sendMessage((Message)new QueryMessage((Object)this));
    }
}

