/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.hbci.server.Cache;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractHibiscusTransferImpl
extends AbstractHibiscusDBObject
implements HibiscusTransfer {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public Object getAttribute(String arg0) throws RemoteException {
        if ("konto_id".equals(arg0)) {
            return this.getKonto();
        }
        if ("mergedzweck".equals(arg0)) {
            return VerwendungszweckUtil.toString(this);
        }
        VerwendungszweckUtil.Tag tag = VerwendungszweckUtil.Tag.byName(arg0);
        if (tag != null) {
            return VerwendungszweckUtil.getTag(this, tag);
        }
        return super.getAttribute(arg0);
    }

    public void overwrite(DBObject object) throws RemoteException {
        super.overwrite(object);
        this.setKonto(((AbstractHibiscusTransferImpl)object).getKonto());
    }

    protected void insertCheck() throws ApplicationException {
        try {
            if (this.getKonto() == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus."));
            }
            if (this.getKonto().isNewObject()) {
                throw new ApplicationException(i18n.tr("Bitte speichern Sie zun\u00e4chst das Konto"));
            }
            if (this.getGegenkontoNummer() == null || this.getGegenkontoNummer().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die Kontonummer des Gegenkontos ein"));
            }
            if (this.getGegenkontoBLZ() == null || this.getGegenkontoBLZ().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die BLZ des Gegenkontos ein"));
            }
            HBCIProperties.checkChars(this.getGegenkontoNummer(), HBCIProperties.HBCI_KTO_VALIDCHARS);
            HBCIProperties.checkChars(this.getGegenkontoBLZ(), HBCIProperties.HBCI_BLZ_VALIDCHARS);
            HBCIProperties.checkLength(this.getGegenkontoNummer(), HBCIProperties.HBCI_KTO_MAXLENGTH_HARD);
            double betrag = this.getBetrag();
            if (betrag == 0.0 || Double.isNaN(betrag)) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen g\u00fcltigen Betrag ein."));
            }
            if (StringUtils.trimToNull((String)this.getGegenkontoName()) == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie den Namen des Kontoinhabers des Gegenkontos ein"));
            }
            int blzLen = this.getGegenkontoBLZ().length();
            if (blzLen != HBCIProperties.HBCI_BLZ_LENGTH) {
                throw new ApplicationException(i18n.tr("Ung\u00fcltige BLZ \"{0}\". Muss {1} Stellen lang sein.", new String[]{this.getGegenkontoBLZ(), "" + HBCIProperties.HBCI_BLZ_LENGTH}));
            }
            HBCIProperties.checkLength(this.getGegenkontoName(), HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH);
            HBCIProperties.checkChars(this.getGegenkontoName(), HBCIProperties.HBCI_DTAUS_VALIDCHARS);
            if (!HBCIProperties.checkAccountCRC(this.getGegenkontoBLZ(), this.getGegenkontoNummer())) {
                throw new ApplicationException(i18n.tr("Ung\u00fcltige BLZ/Kontonummer. Bitte pr\u00fcfen Sie Ihre Eingaben."));
            }
            if (this.getZweck() == null || "".equals(this.getZweck())) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Verwendungszweck ein"));
            }
            HBCIProperties.checkLength(this.getZweck(), HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkLength(this.getZweck2(), HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(this.getZweck(), HBCIProperties.HBCI_DTAUS_VALIDCHARS);
            HBCIProperties.checkChars(this.getZweck2(), HBCIProperties.HBCI_DTAUS_VALIDCHARS);
            VerwendungszweckUtil.checkMaxUsage(this);
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking transfer", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des Auftrages."));
        }
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public Konto getKonto() throws RemoteException {
        Integer i = (Integer)super.getAttribute("konto_id");
        if (i == null) {
            return null;
        }
        Cache cache = Cache.get(Konto.class, true);
        return (Konto)cache.get(i);
    }

    @Override
    public double getBetrag() throws RemoteException {
        Double d = (Double)this.getAttribute("betrag");
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public String getZweck() throws RemoteException {
        return (String)this.getAttribute("zweck");
    }

    @Override
    public String getZweck2() throws RemoteException {
        return (String)this.getAttribute("zweck2");
    }

    @Override
    public void setKonto(Konto konto) throws RemoteException {
        this.setAttribute("konto_id", konto == null || konto.getID() == null ? null : Integer.valueOf(konto.getID()));
    }

    @Override
    public void setBetrag(double betrag) throws RemoteException {
        this.setAttribute("betrag", betrag);
    }

    @Override
    public void setZweck(String zweck) throws RemoteException {
        this.setAttribute("zweck", zweck);
    }

    @Override
    public void setZweck2(String zweck2) throws RemoteException {
        this.setAttribute("zweck2", zweck2);
    }

    @Override
    public String getGegenkontoNummer() throws RemoteException {
        return (String)this.getAttribute("empfaenger_konto");
    }

    @Override
    public String getGegenkontoBLZ() throws RemoteException {
        return (String)this.getAttribute("empfaenger_blz");
    }

    @Override
    public String getGegenkontoName() throws RemoteException {
        return (String)this.getAttribute("empfaenger_name");
    }

    @Override
    public void setGegenkontoNummer(String konto) throws RemoteException {
        this.setAttribute("empfaenger_konto", konto != null ? konto.toUpperCase() : null);
    }

    @Override
    public void setGegenkontoBLZ(String blz) throws RemoteException {
        this.setAttribute("empfaenger_blz", blz);
    }

    @Override
    public void setGegenkontoName(String name) throws RemoteException {
        this.setAttribute("empfaenger_name", name);
    }

    @Override
    public void delete() throws RemoteException, ApplicationException {
        try {
            this.transactionBegin();
            super.delete();
            Konto k = this.getKonto();
            if (k != null) {
                k.addToProtokoll(i18n.tr("Auftrag [Gegenkonto: {0}, Kto. {1}, BLZ {2}] {3} {4} gel\u00f6scht", new String[]{this.getGegenkontoName(), this.getGegenkontoNummer(), this.getGegenkontoBLZ(), k.getWaehrung(), HBCI.DECIMALFORMAT.format(this.getBetrag())}), 1);
            }
            this.transactionCommit();
        }
        catch (ApplicationException | RemoteException e) {
            this.transactionRollback();
            throw e;
        }
    }

    @Override
    public void setGegenkonto(Address e) throws RemoteException {
        if (e == null) {
            return;
        }
        this.setGegenkontoNummer(e.getIban());
        this.setGegenkontoBLZ(e.getBic());
        this.setGegenkontoName(e.getName());
    }

    @Override
    public String[] getWeitereVerwendungszwecke() throws RemoteException {
        return VerwendungszweckUtil.split((String)this.getAttribute("zweck3"));
    }

    @Override
    public void setWeitereVerwendungszwecke(String[] list) throws RemoteException {
        this.setAttribute("zweck3", VerwendungszweckUtil.merge(list));
    }

    @Override
    public void store() throws RemoteException, ApplicationException {
        try {
            this.transactionBegin();
            super.store();
            Konto k = this.getKonto();
            String blz = this.getGegenkontoBLZ();
            if (blz != null) {
                String[] params = new String[]{this.getGegenkontoName(), this.getGegenkontoNummer(), this.getGegenkontoBLZ(), k.getWaehrung(), HBCI.DECIMALFORMAT.format(this.getBetrag())};
                k.addToProtokoll(i18n.tr("Auftrag [Gegenkonto: {0}, Kto. {1}, BLZ {2}] {3} {4} gespeichert", params), 1);
            } else {
                String[] params = new String[]{this.getGegenkontoName(), this.getGegenkontoNummer(), k.getWaehrung(), HBCI.DECIMALFORMAT.format(this.getBetrag())};
                k.addToProtokoll(i18n.tr("Auftrag [Gegenkonto: {0}, Kto. {1}] {2} {3} gespeichert", params), 1);
            }
            this.transactionCommit();
        }
        catch (ApplicationException | RemoteException e) {
            try {
                this.transactionRollback();
            }
            catch (Exception e2) {
                Logger.error((String)"unable to rollback transaction", (Throwable)e2);
            }
            throw e;
        }
    }
}

