/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSammelTransferBuchungImpl
extends AbstractHibiscusDBObject
implements SammelTransferBuchung,
Duplicatable {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public String getPrimaryAttribute() throws RemoteException {
        return "zweck";
    }

    protected void insertCheck() throws ApplicationException {
        try {
            if (this.getSammelTransfer() == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie den zugeh\u00f6rigen Sammel-Auftrag aus."));
            }
            double betrag = this.getBetrag();
            if (betrag == 0.0 || Double.isNaN(betrag)) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen g\u00fcltigen Betrag ein."));
            }
            if (this.getGegenkontoNummer() == null || this.getGegenkontoNummer().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die Kontonummer des Gegenkontos ein"));
            }
            if (this.getGegenkontoBLZ() == null || this.getGegenkontoBLZ().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die BLZ des Gegenkontos ein"));
            }
            HBCIProperties.checkChars(this.getGegenkontoNummer(), HBCIProperties.HBCI_KTO_VALIDCHARS);
            HBCIProperties.checkChars(this.getGegenkontoBLZ(), HBCIProperties.HBCI_BLZ_VALIDCHARS);
            HBCIProperties.checkLength(this.getGegenkontoNummer(), HBCIProperties.HBCI_KTO_MAXLENGTH_HARD);
            if (StringUtils.trimToNull((String)this.getGegenkontoName()) == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie den Namen des Kontoinhabers des Gegenkontos ein"));
            }
            int blzLen = this.getGegenkontoBLZ().length();
            if (blzLen != HBCIProperties.HBCI_BLZ_LENGTH) {
                throw new ApplicationException(i18n.tr("Ung\u00fcltige BLZ \"{0}\". Muss {1} Stellen lang sein.", new String[]{this.getGegenkontoBLZ(), "" + HBCIProperties.HBCI_BLZ_LENGTH}));
            }
            HBCIProperties.checkLength(this.getGegenkontoName(), HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH);
            HBCIProperties.checkChars(this.getGegenkontoName(), HBCIProperties.HBCI_DTAUS_VALIDCHARS);
            if (!HBCIProperties.checkAccountCRC(this.getGegenkontoBLZ(), this.getGegenkontoNummer())) {
                throw new ApplicationException(i18n.tr("Ung\u00fcltige BLZ/Kontonummer. Bitte pr\u00fcfen Sie Ihre Eingaben."));
            }
            if (this.getZweck() == null || "".equals(this.getZweck())) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Verwendungszweck ein"));
            }
            HBCIProperties.checkLength(this.getZweck(), HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkLength(this.getZweck2(), HBCIProperties.HBCI_TRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(this.getZweck(), HBCIProperties.HBCI_DTAUS_VALIDCHARS);
            HBCIProperties.checkChars(this.getZweck2(), HBCIProperties.HBCI_DTAUS_VALIDCHARS);
            VerwendungszweckUtil.checkMaxUsage(this);
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking sammeltransferbuchung", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen der Buchung."));
        }
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public String getGegenkontoNummer() throws RemoteException {
        return (String)this.getAttribute("gegenkonto_nr");
    }

    @Override
    public String getGegenkontoBLZ() throws RemoteException {
        return (String)this.getAttribute("gegenkonto_blz");
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if ("this".equals(arg0)) {
            return this;
        }
        return super.getAttribute(arg0);
    }

    @Override
    public String getGegenkontoName() throws RemoteException {
        return (String)this.getAttribute("gegenkonto_name");
    }

    @Override
    public void setGegenkontoNummer(String kontonummer) throws RemoteException {
        this.setAttribute("gegenkonto_nr", kontonummer);
    }

    @Override
    public void setGegenkontoBLZ(String blz) throws RemoteException {
        this.setAttribute("gegenkonto_blz", blz);
    }

    @Override
    public void setGegenkontoName(String name) throws RemoteException {
        this.setAttribute("gegenkonto_name", name);
    }

    @Override
    public double getBetrag() throws RemoteException {
        Double d = (Double)this.getAttribute("betrag");
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public String getZweck() throws RemoteException {
        return (String)this.getAttribute("zweck");
    }

    @Override
    public String getZweck2() throws RemoteException {
        return (String)this.getAttribute("zweck2");
    }

    @Override
    public void setBetrag(double betrag) throws RemoteException {
        this.setAttribute("betrag", betrag);
    }

    @Override
    public void setZweck(String zweck) throws RemoteException {
        this.setAttribute("zweck", zweck);
    }

    @Override
    public void setZweck2(String zweck2) throws RemoteException {
        this.setAttribute("zweck2", zweck2);
    }

    public Duplicatable duplicate() throws RemoteException {
        SammelTransferBuchung b = (SammelTransferBuchung)this.getService().createObject(this.getClass(), null);
        b.setBetrag(this.getBetrag());
        b.setGegenkontoBLZ(this.getGegenkontoBLZ());
        b.setGegenkontoNummer(this.getGegenkontoNummer());
        b.setGegenkontoName(this.getGegenkontoName());
        b.setSammelTransfer(this.getSammelTransfer());
        b.setZweck(this.getZweck());
        b.setZweck2(this.getZweck2());
        b.setWeitereVerwendungszwecke(this.getWeitereVerwendungszwecke());
        b.setTextSchluessel(this.getTextSchluessel());
        return (Duplicatable)((Object)b);
    }

    @Override
    public String getTextSchluessel() throws RemoteException {
        return (String)this.getAttribute("typ");
    }

    @Override
    public void setTextSchluessel(String schluessel) throws RemoteException {
        this.setAttribute("typ", schluessel);
    }

    @Override
    public String[] getWeitereVerwendungszwecke() throws RemoteException {
        return VerwendungszweckUtil.split((String)this.getAttribute("zweck3"));
    }

    @Override
    public void setWeitereVerwendungszwecke(String[] list) throws RemoteException {
        this.setAttribute("zweck3", VerwendungszweckUtil.merge(list));
    }

    @Override
    public String getWarnung() throws RemoteException {
        return (String)this.getAttribute("warnung");
    }

    @Override
    public void setWarnung(String warnung) throws RemoteException {
        this.setAttribute("warnung", warnung);
    }
}

