/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;

public abstract class AbstractSammelTransferImpl
extends AbstractHibiscusDBObject
implements SammelTransfer,
Terminable {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private boolean whileStore = false;

    public String getPrimaryAttribute() throws RemoteException {
        return "bezeichnung";
    }

    protected void insertCheck() throws ApplicationException {
        try {
            if (this.getKonto() == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus."));
            }
            if (this.getKonto().isNewObject()) {
                throw new ApplicationException(i18n.tr("Bitte speichern Sie zun\u00e4chst das Konto"));
            }
            if (this.getTermin() == null) {
                this.setTermin(new Date());
            }
            if (this.getBezeichnung() == null || this.getBezeichnung().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie eine Bezeichnung ein."));
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking sammeltransfer", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des Auftrags."));
        }
    }

    protected void updateCheck() throws ApplicationException {
        try {
            if (!this.whileStore && this.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("Auftrag wurde bereits ausgef\u00fchrt und kann daher nicht mehr ge\u00e4ndert werden."));
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking sammeltransfer", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des Auftrags."));
        }
        this.insertCheck();
    }

    public void insert() throws RemoteException, ApplicationException {
        if (this.getAttribute("ausgefuehrt") == null) {
            this.setAttribute("ausgefuehrt", 0);
        }
        super.insert();
    }

    protected Class getForeignObject(String arg0) throws RemoteException {
        if ("konto_id".equals(arg0)) {
            return Konto.class;
        }
        return null;
    }

    @Override
    public Konto getKonto() throws RemoteException {
        return (Konto)this.getAttribute("konto_id");
    }

    @Override
    public void setKonto(Konto konto) throws RemoteException {
        this.setAttribute("konto_id", konto);
    }

    @Override
    public Date getTermin() throws RemoteException {
        return (Date)this.getAttribute("termin");
    }

    @Override
    public Date getAusfuehrungsdatum() throws RemoteException {
        return (Date)this.getAttribute("ausgefuehrt_am");
    }

    @Override
    public boolean ausgefuehrt() throws RemoteException {
        Integer i = (Integer)this.getAttribute("ausgefuehrt");
        if (i == null) {
            return false;
        }
        return i == 1;
    }

    @Override
    public void setAusgefuehrt(boolean b) throws RemoteException, ApplicationException {
        try {
            this.whileStore = true;
            this.setAttribute("ausgefuehrt", b ? 1 : 0);
            this.setAttribute("ausgefuehrt_am", new Date());
            this.store();
            Logger.info((String)("[" + this.getTableName() + ":" + this.getID() + "] (" + BeanUtil.toString((Object)this) + ") - executed: " + b));
        }
        finally {
            this.whileStore = false;
        }
    }

    @Override
    public void setTermin(Date termin) throws RemoteException {
        this.setAttribute("termin", termin);
    }

    @Override
    public boolean ueberfaellig() throws RemoteException {
        if (this.ausgefuehrt()) {
            return false;
        }
        Date termin = this.getTermin();
        if (termin == null) {
            return false;
        }
        return termin.before(new Date());
    }

    @Override
    public String getBezeichnung() throws RemoteException {
        return (String)this.getAttribute("bezeichnung");
    }

    @Override
    public void setBezeichnung(String bezeichnung) throws RemoteException {
        this.setAttribute("bezeichnung", bezeichnung);
    }

    @Override
    public void delete() throws RemoteException, ApplicationException {
        try {
            this.transactionBegin();
            int count = 0;
            DBIterator list = this.getBuchungen();
            SammelTransferBuchung b = null;
            while (list.hasNext()) {
                b = (SammelTransferBuchung)list.next();
                b.delete();
                ++count;
            }
            super.delete();
            Konto k = this.getKonto();
            if (k != null) {
                k.addToProtokoll(i18n.tr("Sammel-Auftrag [Bezeichnung: {0}] gel\u00f6scht. Enthaltene Buchungen: {1}", new String[]{this.getBezeichnung(), Integer.toString(count)}), 1);
            }
            this.transactionCommit();
        }
        catch (ApplicationException | RemoteException e) {
            this.transactionRollback();
            throw e;
        }
    }

    @Override
    public void store() throws RemoteException, ApplicationException {
        super.store();
        Konto k = this.getKonto();
        k.addToProtokoll(i18n.tr("Sammel-Auftrag [Bezeichnung: {0}] gespeichert", this.getBezeichnung()), 1);
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if ("summe".equals(arg0)) {
            return this.getSumme();
        }
        if ("anzahl".equals(arg0)) {
            try {
                DBIterator l = this.getBuchungen();
                return l.size();
            }
            catch (RemoteException e) {
                Logger.error((String)"unable to determine number of buchungen", (Throwable)e);
                return 0;
            }
        }
        if ("buchungen".equals(arg0)) {
            try {
                StringBuffer sb = new StringBuffer();
                DBIterator di = this.getBuchungen();
                while (di.hasNext()) {
                    SammelTransferBuchung b = (SammelTransferBuchung)di.next();
                    String[] params = new String[]{HBCI.DECIMALFORMAT.format(b.getBetrag()), this.getKonto().getWaehrung(), b.getGegenkontoName()};
                    sb.append(i18n.tr("{0} {1} \t {2}", params));
                    if (!di.hasNext()) continue;
                    sb.append("\n");
                }
                return sb.toString();
            }
            catch (RemoteException e) {
                Logger.error((String)"error while reading buchungen", (Throwable)e);
                return i18n.tr("Buchungen nicht lesbar");
            }
        }
        return super.getAttribute(arg0);
    }

    @Override
    public double getSumme() throws RemoteException {
        double sum = 0.0;
        DBIterator list = this.getBuchungen();
        while (list.hasNext()) {
            SammelTransferBuchung b = (SammelTransferBuchung)list.next();
            sum += b.getBetrag();
        }
        return sum;
    }

    @Override
    public SammelTransferBuchung[] getBuchungenAsArray() throws RemoteException {
        ArrayList<GenericObject> buchungen = new ArrayList<GenericObject>();
        DBIterator list = this.getBuchungen();
        while (list.hasNext()) {
            buchungen.add(list.next());
        }
        return buchungen.toArray(new SammelTransferBuchung[0]);
    }

    @Override
    public boolean hasWarnings() throws RemoteException {
        Integer i = (Integer)this.getAttribute("warnungen");
        if (i == null) {
            return false;
        }
        return i == 1;
    }

    @Override
    public void setWarning(boolean b) throws RemoteException {
        this.setAttribute("warnungen", b ? 1 : 0);
    }
}

