/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransferBuchung;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSepaSammelTransferBuchungImpl<T extends SepaSammelTransfer>
extends AbstractHibiscusDBObject
implements SepaSammelTransferBuchung<T>,
Duplicatable {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public String getPrimaryAttribute() throws RemoteException {
        return "zweck";
    }

    protected void insertCheck() throws ApplicationException {
        try {
            if (this.getSammelTransfer() == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie den zugeh\u00f6rigen Sammel-Auftrag aus."));
            }
            double betrag = this.getBetrag();
            if (betrag == 0.0 || Double.isNaN(betrag)) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen g\u00fcltigen Betrag ein."));
            }
            String s = StringUtils.trimToNull((String)this.getGegenkontoNummer());
            if (s == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die IBAN des Gegenkontos ein"));
            }
            HBCIProperties.checkChars(s, HBCIProperties.HBCI_IBAN_VALIDCHARS);
            HBCIProperties.checkLength(s, HBCIProperties.HBCI_IBAN_MAXLENGTH);
            HBCIProperties.checkIBAN(s);
            if (StringUtils.trimToNull((String)this.getGegenkontoBLZ()) != null) {
                HBCIProperties.checkBIC(this.getGegenkontoBLZ());
            }
            if (StringUtils.trimToNull((String)this.getGegenkontoName()) == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie den Namen des Kontoinhabers des Gegenkontos ein"));
            }
            HBCIProperties.checkLength(this.getGegenkontoName(), HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(this.getGegenkontoName(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getZweck(), HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(this.getZweck(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getEndtoEndId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            HBCIProperties.checkChars(this.getEndtoEndId(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getPurposeCode(), HBCIProperties.HBCI_SEPA_PURPOSECODE_MAXLENGTH);
            HBCIProperties.checkChars(this.getPurposeCode(), HBCIProperties.HBCI_SEPA_PURPOSECODE_VALIDCHARS);
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking sammeltransferbuchung", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen der Buchung."));
        }
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public String getGegenkontoNummer() throws RemoteException {
        return (String)this.getAttribute("empfaenger_konto");
    }

    @Override
    public String getGegenkontoBLZ() throws RemoteException {
        return (String)this.getAttribute("empfaenger_bic");
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if ("this".equals(arg0)) {
            return this;
        }
        return super.getAttribute(arg0);
    }

    @Override
    public String getGegenkontoName() throws RemoteException {
        return (String)this.getAttribute("empfaenger_name");
    }

    @Override
    public void setGegenkontoNummer(String kontonummer) throws RemoteException {
        this.setAttribute("empfaenger_konto", kontonummer != null ? kontonummer.toUpperCase() : null);
    }

    @Override
    public void setGegenkontoBLZ(String blz) throws RemoteException {
        this.setAttribute("empfaenger_bic", blz);
    }

    @Override
    public void setGegenkontoName(String name) throws RemoteException {
        this.setAttribute("empfaenger_name", name);
    }

    @Override
    public double getBetrag() throws RemoteException {
        Double d = (Double)this.getAttribute("betrag");
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public String getZweck() throws RemoteException {
        return (String)this.getAttribute("zweck");
    }

    @Override
    public String getZweck2() throws RemoteException {
        return null;
    }

    @Override
    public void setBetrag(double betrag) throws RemoteException {
        this.setAttribute("betrag", betrag);
    }

    @Override
    public void setZweck(String zweck) throws RemoteException {
        this.setAttribute("zweck", zweck);
    }

    public Duplicatable duplicate() throws RemoteException {
        SepaSammelTransferBuchung b = (SepaSammelTransferBuchung)this.getService().createObject(this.getClass(), null);
        b.setBetrag(this.getBetrag());
        b.setGegenkontoBLZ(this.getGegenkontoBLZ());
        b.setGegenkontoNummer(this.getGegenkontoNummer());
        b.setGegenkontoName(this.getGegenkontoName());
        b.setSammelTransfer(this.getSammelTransfer());
        b.setZweck(this.getZweck());
        b.setEndtoEndId(this.getEndtoEndId());
        b.setPurposeCode(this.getPurposeCode());
        return (Duplicatable)((Object)b);
    }

    @Override
    public String[] getWeitereVerwendungszwecke() throws RemoteException {
        return null;
    }

    @Override
    public String getEndtoEndId() throws RemoteException {
        return (String)this.getAttribute("endtoendid");
    }

    @Override
    public void setEndtoEndId(String id) throws RemoteException {
        this.setAttribute("endtoendid", id);
    }

    @Override
    public String getPurposeCode() throws RemoteException {
        return (String)this.getAttribute("purposecode");
    }

    @Override
    public void setPurposeCode(String code) throws RemoteException {
        this.setAttribute("purposecode", code);
    }
}

