/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransferBuchung;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.hbci.server.Cache;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

public abstract class AbstractSepaSammelTransferImpl<T extends SepaSammelTransferBuchung>
extends AbstractHibiscusDBObject
implements SepaSammelTransfer<T>,
Duplicatable,
Terminable {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private boolean markingExecuted = false;

    public String getPrimaryAttribute() throws RemoteException {
        return "bezeichnung";
    }

    protected void insertCheck() throws ApplicationException {
        try {
            Konto k = this.getKonto();
            if (k == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus."));
            }
            if (k.isNewObject()) {
                throw new ApplicationException(i18n.tr("Bitte speichern Sie zun\u00e4chst das Konto"));
            }
            String kiban = k.getIban();
            if (kiban == null || kiban.length() == 0) {
                throw new ApplicationException(i18n.tr("Das ausgew\u00e4hlte Konto besitzt keine IBAN"));
            }
            String bic = k.getBic();
            if (bic == null || bic.length() == 0) {
                throw new ApplicationException(i18n.tr("Das ausgew\u00e4hlte Konto besitzt keine BIC"));
            }
            if (this.getBezeichnung() == null || this.getBezeichnung().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie eine Bezeichnung ein."));
            }
            HBCIProperties.checkLength(this.getPmtInfId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            HBCIProperties.checkChars(this.getPmtInfId(), HBCIProperties.HBCI_SEPA_PMTINF_VALIDCHARS);
            if (this.getTermin() == null) {
                this.setTermin(new Date());
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking job", (Throwable)e);
            if (!this.markingExecuted()) {
                throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des SEPA-Auftrages."));
            }
        }
        catch (ApplicationException ae) {
            if (!this.markingExecuted()) {
                throw ae;
            }
            Logger.warn((String)ae.getMessage());
        }
    }

    protected void updateCheck() throws ApplicationException {
        try {
            if (!this.markingExecuted() && this.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("Auftrag wurde bereits ausgef\u00fchrt und kann daher nicht mehr ge\u00e4ndert werden."));
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking sammeltransfer", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des Auftrags."));
        }
        this.insertCheck();
    }

    public void insert() throws RemoteException, ApplicationException {
        if (this.getAttribute("ausgefuehrt") == null) {
            this.setAttribute("ausgefuehrt", 0);
        }
        super.insert();
    }

    @Override
    public Konto getKonto() throws RemoteException {
        Integer i = (Integer)super.getAttribute("konto_id");
        if (i == null) {
            return null;
        }
        Cache cache = Cache.get(Konto.class, true);
        return (Konto)cache.get(i);
    }

    @Override
    public void setKonto(Konto k) throws RemoteException {
        this.setAttribute("konto_id", k == null || k.getID() == null ? null : Integer.valueOf(k.getID()));
    }

    @Override
    public Date getTermin() throws RemoteException {
        return (Date)this.getAttribute("termin");
    }

    @Override
    public Date getAusfuehrungsdatum() throws RemoteException {
        return (Date)this.getAttribute("ausgefuehrt_am");
    }

    @Override
    public boolean ausgefuehrt() throws RemoteException {
        Integer i = (Integer)this.getAttribute("ausgefuehrt");
        if (i == null) {
            return false;
        }
        return i == 1;
    }

    protected boolean markingExecuted() {
        return this.markingExecuted;
    }

    @Override
    public void setAusgefuehrt(boolean b) throws RemoteException, ApplicationException {
        try {
            this.markingExecuted = true;
            this.setAttribute("ausgefuehrt", b ? 1 : 0);
            this.setAttribute("ausgefuehrt_am", new Date());
            this.store();
            Logger.info((String)("[" + this.getTableName() + ":" + this.getID() + "] (" + BeanUtil.toString((Object)this) + ") - executed: " + b));
        }
        finally {
            this.markingExecuted = false;
        }
    }

    @Override
    public void setTermin(Date termin) throws RemoteException {
        this.setAttribute("termin", termin);
    }

    @Override
    public boolean ueberfaellig() throws RemoteException {
        if (this.ausgefuehrt()) {
            return false;
        }
        Date termin = this.getTermin();
        if (termin == null) {
            return false;
        }
        return termin.before(new Date());
    }

    @Override
    public String getBezeichnung() throws RemoteException {
        return (String)this.getAttribute("bezeichnung");
    }

    @Override
    public void setBezeichnung(String bezeichnung) throws RemoteException {
        this.setAttribute("bezeichnung", bezeichnung);
    }

    @Override
    public void delete() throws RemoteException, ApplicationException {
        try {
            this.transactionBegin();
            int count = 0;
            List list = this.getBuchungen();
            for (SepaSammelTransferBuchung b : list) {
                b.delete();
                ++count;
            }
            super.delete();
            Konto k = this.getKonto();
            if (k != null) {
                k.addToProtokoll(i18n.tr("Sammel-Auftrag [Bezeichnung: {0}] gel\u00f6scht. Enthaltene Buchungen: {1}", new String[]{this.getBezeichnung(), Integer.toString(count)}), 1);
            }
            this.transactionCommit();
        }
        catch (ApplicationException | RemoteException e) {
            this.transactionRollback();
            throw e;
        }
    }

    @Override
    public void store() throws RemoteException, ApplicationException {
        super.store();
        this.getKonto().addToProtokoll(i18n.tr("Sammel-Auftrag [Bezeichnung: {0}] gespeichert", this.getBezeichnung()), 1);
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if ("summe".equals(arg0)) {
            return this.getSumme();
        }
        if ("anzahl".equals(arg0)) {
            return this.getBuchungen().size();
        }
        if ("buchungen".equals(arg0)) {
            StringBuffer sb = new StringBuffer();
            List list = this.getBuchungen();
            for (SepaSammelTransferBuchung t : list) {
                sb.append(i18n.tr("{0} {1} \t {2}\n", new String[]{HBCI.DECIMALFORMAT.format(t.getBetrag()), HBCIProperties.CURRENCY_DEFAULT_DE, t.getGegenkontoName()}));
            }
            return sb.toString();
        }
        if ("konto_id".equals(arg0)) {
            return this.getKonto();
        }
        return super.getAttribute(arg0);
    }

    @Override
    public BigDecimal getSumme() throws RemoteException {
        BigDecimal sum = new BigDecimal(0);
        if (this.isNewObject()) {
            return sum;
        }
        List list = this.getBuchungen();
        for (SepaSammelTransferBuchung t : list) {
            sum = sum.add(new BigDecimal(t.getBetrag()));
        }
        return sum;
    }

    @Override
    public String getPmtInfId() throws RemoteException {
        return (String)this.getAttribute("pmtinfid");
    }

    @Override
    public void setPmtInfId(String id) throws RemoteException {
        this.setAttribute("pmtinfid", id);
    }
}

