/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.rmi.DBSupport;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.server.DBSupportH2Impl;
import de.willuhn.jameica.hbci.server.HBCIUpdateProvider;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.sql.ScriptExecutor;
import de.willuhn.sql.version.Update;
import de.willuhn.sql.version.UpdateProvider;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.util.List;

public abstract class AbstractUpdate
implements Update {
    public void execute(UpdateProvider provider) throws ApplicationException {
        HBCIUpdateProvider myProvider = (HBCIUpdateProvider)provider;
        I18N i18n = myProvider.getResources().getI18N();
        try {
            String driver = HBCIDBService.SETTINGS.getString("database.driver", DBSupportH2Impl.class.getName());
            Class driverClass = Application.getClassLoader().load(driver);
            List<String> sql = this.getStatements(driverClass);
            if (sql == null) {
                throw new ApplicationException(i18n.tr("Datenbank {0} nicht wird unterst\u00fctzt", driver));
            }
            if (sql.size() == 0) {
                myProvider.getProgressMonitor().log(i18n.tr("Update \u00fcbersprungen, nicht notwendig"));
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (String s : sql) {
                sb.append(s);
                sb.append("\n");
            }
            ScriptExecutor.execute((Reader)new StringReader(sb.toString()), (Connection)myProvider.getConnection(), (ProgressMonitor)myProvider.getProgressMonitor());
            myProvider.getProgressMonitor().log(i18n.tr("Tabelle aktualisiert"));
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to execute update", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Ausf\u00fchren des Updates"), (Throwable)e);
        }
    }

    protected abstract List<String> getStatements(Class<? extends DBSupport> var1);

    public String getName() {
        return "database update " + this.getClass().getSimpleName();
    }
}

