/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.jost_net.OBanToo.SEPA.IBAN;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.Addressbook;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.manager.HBCIUtils;

public class AddressbookHibiscusImpl
extends UnicastRemoteObject
implements Addressbook {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public Address contains(Address address) throws RemoteException {
        if (address == null) {
            return null;
        }
        DBIterator list = Settings.getDBService().createList(HibiscusAddress.class);
        Address a = (Address)this.contains(list, address);
        if (a != null) {
            return a;
        }
        list = Settings.getDBService().createList(Konto.class);
        Konto k = (Konto)this.contains(list, address);
        if (k != null) {
            return new KontoAddress(k);
        }
        return null;
    }

    @Override
    public List findAddresses(String text) throws RemoteException {
        String s;
        ArrayList<Address> result = new ArrayList<Address>();
        DBIterator list = Settings.getDBService().createList(HibiscusAddress.class);
        if (text != null && text.length() > 0) {
            s = "%" + text.toLowerCase() + "%";
            list.addFilter("(kontonummer LIKE ? OR  LOWER(iban) LIKE ? OR  blz LIKE ? OR  LOWER(kategorie) LIKE ? OR  LOWER(name) LIKE ? OR  LOWER(kommentar) LIKE ?)", new Object[]{s, s, s, s, s, s});
        }
        list.setOrder("ORDER by LOWER(name)");
        while (list.hasNext()) {
            HibiscusAddress a = (HibiscusAddress)list.next();
            this.completeIBAN(a);
            result.add(a);
        }
        list = Settings.getDBService().createList(Konto.class);
        if (text != null && text.length() > 0) {
            s = "%" + text.toLowerCase() + "%";
            list.addFilter("(kontonummer LIKE ? OR  blz LIKE ? OR  LOWER(name) LIKE ? OR  LOWER(kommentar) LIKE ?)", new Object[]{s, s, s, s});
        }
        while (list.hasNext()) {
            Konto k = (Konto)list.next();
            if (k.hasFlag(1)) continue;
            result.add(new KontoAddress(k));
        }
        return result;
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("Hibiscus-Adressbuch");
    }

    private GenericObject contains(DBIterator it, Address a) throws RemoteException {
        String kto = StringUtils.trimToNull((String)a.getKontonummer());
        String iban = StringUtils.trimToNull((String)a.getIban());
        String name = StringUtils.trimToNull((String)a.getName());
        if (iban != null) {
            it.addFilter("LOWER(iban)=?", new Object[]{iban.toLowerCase()});
        } else {
            it.addFilter("kontonummer like ?", new Object[]{"%" + kto});
            it.addFilter("blz=?", new Object[]{a.getBlz()});
        }
        if (name != null) {
            it.addFilter("LOWER(name)=?", new Object[]{name.toLowerCase()});
        }
        return it.hasNext() ? it.next() : null;
    }

    private void completeIBAN(HibiscusAddress address) {
        if (address == null) {
            return;
        }
        try {
            String blz = StringUtils.trimToNull((String)address.getBlz());
            String konto = StringUtils.trimToNull((String)address.getKontonummer());
            if (blz == null || konto == null) {
                return;
            }
            boolean haveChanged = false;
            String bic = null;
            if (HBCI.COMPLETE_IBAN && StringUtils.trimToNull((String)address.getIban()) == null) {
                IBAN iban = HBCIProperties.getIBAN(blz, konto);
                bic = iban.getBIC();
                address.setIban(iban.getIBAN());
                haveChanged = true;
            }
            if (StringUtils.trimToNull((String)address.getBic()) == null) {
                if (bic == null) {
                    bic = HBCIUtils.getBICForBLZ((String)blz);
                }
                if (StringUtils.trimToNull(bic) != null) {
                    address.setBic(bic);
                    haveChanged = true;
                }
            }
            if (haveChanged) {
                address.store();
                Logger.debug((String)"auto-completed IBAN/BIC for address");
            }
        }
        catch (ApplicationException ae) {
            Logger.warn((String)("unable to complete IBAN/BIC for address: " + ae.getMessage()));
        }
        catch (Exception e) {
            Logger.error((String)"unable to complete IBAN/BIC for address", (Throwable)e);
        }
    }

    public class KontoAddress
    implements Address {
        private Konto konto = null;

        private KontoAddress(Konto konto) {
            this.konto = konto;
        }

        @Override
        public String getBlz() throws RemoteException {
            return this.konto.getBLZ();
        }

        @Override
        public String getKommentar() throws RemoteException {
            return this.konto.getKommentar();
        }

        @Override
        public String getKontonummer() throws RemoteException {
            return this.konto.getKontonummer();
        }

        @Override
        public String getName() throws RemoteException {
            return this.konto.getName();
        }

        @Override
        public String getBic() throws RemoteException {
            return this.konto.getBic();
        }

        @Override
        public String getIban() throws RemoteException {
            return this.konto.getIban();
        }

        @Override
        public String getKategorie() throws RemoteException {
            return i18n.tr("Eigenes Konto");
        }
    }
}

