/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.Addressbook;
import de.willuhn.jameica.hbci.rmi.AddressbookService;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ClassFinder;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;

public class AddressbookServiceImpl
extends UnicastRemoteObject
implements AddressbookService {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private boolean started = false;
    private Addressbook[] books = null;

    @Override
    public List findAddresses(String text) throws RemoteException {
        Addressbook[] books = this.getAddressbooks();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < books.length) {
            List list;
            if (!books[i].getClass().equals(this.getClass()) && (list = books[i].findAddresses(text)) != null) {
                result.addAll(list);
            }
            ++i;
        }
        return result;
    }

    @Override
    public Address contains(Address address) throws RemoteException {
        Addressbook[] books = this.getAddressbooks();
        int i = 0;
        while (i < books.length) {
            Address found;
            if (!books[i].getClass().equals(this.getClass()) && (found = books[i].contains(address)) != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    @Override
    public synchronized Addressbook[] getAddressbooks() throws RemoteException {
        if (this.books == null) {
            try {
                Logger.info((String)"loading addressbooks");
                BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                ClassFinder finder = Application.getPluginLoader().getPlugin(HBCI.class).getManifest().getClassLoader().getClassFinder();
                Class[] found = finder.findImplementors(Addressbook.class);
                ArrayList<Addressbook> list = new ArrayList<Addressbook>();
                list.add(this);
                int i = 0;
                while (i < found.length) {
                    if (!found[i].equals(this.getClass())) {
                        try {
                            Addressbook a = (Addressbook)service.get(found[i]);
                            Logger.info((String)("  " + a.getName()));
                            list.add(a);
                        }
                        catch (Throwable t) {
                            Logger.error((String)("unable to load addressbook " + found[i] + ", skipping"));
                        }
                    }
                    ++i;
                }
                this.books = list.toArray(new Addressbook[0]);
            }
            catch (ClassNotFoundException e) {
                Logger.error((String)"no addressbooks found, suspekt!");
            }
            if (this.books == null || this.books.length == 0) {
                Logger.error((String)"no addressbooks found, suspekt!");
                this.books = new Addressbook[0];
            }
        }
        return this.books;
    }

    @Override
    public boolean hasExternalAddressbooks() throws RemoteException {
        Addressbook[] books = this.getAddressbooks();
        return books != null && books.length > 2;
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("Alle Adressb\u00fccher");
    }

    public boolean isStartable() throws RemoteException {
        return !this.isStarted();
    }

    public boolean isStarted() throws RemoteException {
        return this.started;
    }

    public void start() throws RemoteException {
        if (this.isStarted()) {
            Logger.warn((String)"service already started, skipping request");
            return;
        }
        this.started = true;
    }

    public void stop(boolean arg0) throws RemoteException {
        if (!this.isStarted()) {
            Logger.warn((String)"service not started, skipping request");
            return;
        }
        this.books = null;
        this.started = false;
    }
}

