/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.AbstractBaseUeberweisungImpl;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class AuslandsUeberweisungImpl
extends AbstractBaseUeberweisungImpl
implements AuslandsUeberweisung {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "aueberweisung";
    }

    public Duplicatable duplicate() throws RemoteException {
        AuslandsUeberweisung u = (AuslandsUeberweisung)this.getService().createObject(AuslandsUeberweisung.class, null);
        u.setBetrag(this.getBetrag());
        u.setGegenkontoNummer(this.getGegenkontoNummer());
        u.setGegenkontoName(this.getGegenkontoName());
        u.setGegenkontoBLZ(this.getGegenkontoBLZ());
        u.setKonto(this.getKonto());
        u.setZweck(this.getZweck());
        u.setEndtoEndId(this.getEndtoEndId());
        u.setPmtInfId(this.getPmtInfId());
        u.setTerminUeberweisung(this.isTerminUeberweisung());
        u.setTermin(this.isTerminUeberweisung() ? this.getTermin() : new Date());
        u.setUmbuchung(this.isUmbuchung());
        u.setPurposeCode(this.getPurposeCode());
        u.setInstantPayment(this.isInstantPayment());
        return u;
    }

    @Override
    protected void insertCheck() throws ApplicationException {
        try {
            Konto k = this.getKonto();
            if (k == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus."));
            }
            if (k.isNewObject()) {
                throw new ApplicationException(i18n.tr("Bitte speichern Sie zun\u00e4chst das Konto"));
            }
            String kiban = k.getIban();
            if (kiban == null || kiban.length() == 0) {
                throw new ApplicationException(i18n.tr("Das ausgew\u00e4hlte Konto besitzt keine IBAN"));
            }
            String bic = k.getBic();
            if (bic == null || bic.length() == 0) {
                throw new ApplicationException(i18n.tr("Das ausgew\u00e4hlte Konto besitzt keine BIC"));
            }
            double betrag = this.getBetrag();
            if (betrag == 0.0 || Double.isNaN(betrag)) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen g\u00fcltigen Betrag ein."));
            }
            String s = StringUtils.trimToNull((String)this.getGegenkontoNummer());
            if (s == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die IBAN des Gegenkontos ein"));
            }
            HBCIProperties.checkChars(s, HBCIProperties.HBCI_IBAN_VALIDCHARS);
            HBCIProperties.checkLength(s, HBCIProperties.HBCI_IBAN_MAXLENGTH);
            HBCIProperties.checkIBAN(s);
            if (StringUtils.trimToNull((String)this.getGegenkontoBLZ()) != null) {
                HBCIProperties.checkBIC(this.getGegenkontoBLZ());
            }
            if (StringUtils.trimToNull((String)this.getGegenkontoName()) == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie den Namen des Kontoinhabers des Gegenkontos ein"));
            }
            HBCIProperties.checkLength(this.getGegenkontoName(), HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(this.getGegenkontoName(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getZweck(), HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(this.getZweck(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getEndtoEndId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            HBCIProperties.checkChars(this.getEndtoEndId(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getPmtInfId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            HBCIProperties.checkChars(this.getPmtInfId(), HBCIProperties.HBCI_SEPA_PMTINF_VALIDCHARS);
            HBCIProperties.checkLength(this.getPurposeCode(), HBCIProperties.HBCI_SEPA_PURPOSECODE_MAXLENGTH);
            HBCIProperties.checkChars(this.getPurposeCode(), HBCIProperties.HBCI_SEPA_PURPOSECODE_VALIDCHARS);
            if (this.isUmbuchung() && this.isTerminUeberweisung()) {
                throw new ApplicationException(i18n.tr("Eine Umbuchung kann nicht als Termin-Auftrag gesendet werden"));
            }
            if (this.getTermin() == null) {
                this.setTermin(new Date());
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking job", (Throwable)e);
            if (!this.markingExecuted()) {
                throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des SEPA-Auftrages."));
            }
        }
        catch (ApplicationException ae) {
            if (!this.markingExecuted()) {
                throw ae;
            }
            Logger.warn((String)ae.getMessage());
        }
    }

    @Override
    public boolean isTerminUeberweisung() throws RemoteException {
        Integer i = (Integer)this.getAttribute("banktermin");
        return i != null && i == 1;
    }

    @Override
    public void setTerminUeberweisung(boolean termin) throws RemoteException {
        this.setAttribute("banktermin", termin ? Integer.valueOf(1) : null);
    }

    @Override
    public boolean isUmbuchung() throws RemoteException {
        Integer i = (Integer)this.getAttribute("umbuchung");
        return i != null && i == 1;
    }

    @Override
    public void setUmbuchung(boolean b) throws RemoteException {
        this.setAttribute("umbuchung", b ? Integer.valueOf(1) : null);
    }

    @Override
    public boolean isInstantPayment() throws RemoteException {
        Integer i = (Integer)this.getAttribute("instantpayment");
        return i != null && i == 1;
    }

    @Override
    public void setInstantPayment(boolean b) throws RemoteException {
        this.setAttribute("instantpayment", b ? Integer.valueOf(1) : null);
    }

    @Override
    public boolean ueberfaellig() throws RemoteException {
        if (this.isTerminUeberweisung()) {
            return !this.ausgefuehrt();
        }
        return super.ueberfaellig();
    }

    @Override
    public void setTextSchluessel(String schluessel) throws RemoteException {
        if (schluessel != null && schluessel.length() > 0) {
            throw new RemoteException("textschluessel not allowed for foreign transfer");
        }
    }

    @Override
    public void setGegenkontoBLZ(String blz) throws RemoteException {
        this.setAttribute("empfaenger_bic", blz);
    }

    @Override
    public String getGegenkontoBLZ() throws RemoteException {
        return (String)this.getAttribute("empfaenger_bic");
    }

    @Override
    public void setWeitereVerwendungszwecke(String[] list) throws RemoteException {
        if (list != null && list.length > 0) {
            throw new RemoteException("extended usages not allowed for foreign transfer");
        }
    }

    @Override
    public void setZweck2(String zweck2) throws RemoteException {
        if (zweck2 != null && zweck2.length() > 0) {
            throw new RemoteException("second usage not allowed for foreign transfer");
        }
    }

    @Override
    public String getEndtoEndId() throws RemoteException {
        return (String)this.getAttribute("endtoendid");
    }

    @Override
    public void setEndtoEndId(String id) throws RemoteException {
        this.setAttribute("endtoendid", id);
    }

    @Override
    public String getPmtInfId() throws RemoteException {
        return (String)this.getAttribute("pmtinfid");
    }

    @Override
    public void setPmtInfId(String id) throws RemoteException {
        this.setAttribute("pmtinfid", id);
    }

    @Override
    public String getPurposeCode() throws RemoteException {
        return (String)this.getAttribute("purposecode");
    }

    @Override
    public void setPurposeCode(String code) throws RemoteException {
        this.setAttribute("purposecode", code);
    }
}

