/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Version;
import de.willuhn.jameica.hbci.server.DBPropertyUtil;
import de.willuhn.jameica.hbci.server.VersionUtil;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import de.willuhn.util.TypedProperties;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.kapott.hbci.passport.HBCIPassport;

public class BPDUtil {
    private static final long CACHE_MAX_AGE = 604800000L;
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public static Support getSupport(Konto konto, Query query) {
        String kd;
        block5: {
            if (konto == null || query == null) {
                return null;
            }
            try {
                kd = konto.getKundennummer();
                if (kd != null && kd.length() != 0 && kd.trim().matches("[0-9a-zA-Z]{1,30}")) break block5;
                return null;
            }
            catch (RemoteException re) {
                Logger.error((String)("unable to determine support information of " + query.query), (Throwable)re);
                return null;
            }
        }
        Support support = new Support();
        support.konto = konto;
        support.query = query;
        support.maxVersion = BPDUtil.getMaxVersion(kd, query);
        if (support.maxVersion == null) {
            return support;
        }
        support.bpdSupport = true;
        support.bpd = BPDUtil.getBPD(kd, query, support.maxVersion);
        support.updSupport = BPDUtil.getUPDSupport(konto, query);
        return support;
    }

    private static Integer getMaxVersion(String kd, Query query) throws RemoteException {
        String prefix;
        String q;
        HBCIDBService service = Settings.getDBService();
        String version = (String)service.execute("select max(content) from property where name like ?", new String[]{q = String.valueOf(prefix = String.valueOf(DBPropertyUtil.Prefix.BPD.value()) + '.' + kd.trim() + '.') + "Params%." + query.query + "Par%.SegHead.version"}, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        });
        if (version == null || !version.matches("^[0-9]{1,2}$")) {
            return null;
        }
        return Integer.parseInt(version);
    }

    private static boolean getUPDSupport(final Konto k, final Query query) throws RemoteException {
        String q;
        HBCIDBService service = Settings.getDBService();
        Boolean ignoreUpd = (Boolean)service.execute("select name,content from property where name = ?", new String[]{q = String.valueOf(DBPropertyUtil.Prefix.UPD.value()) + '.' + k.getKundennummer() + '.' + "UPA.usage"}, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                if (rs.next()) {
                    return Objects.equals(rs.getString("content"), "1");
                }
                return Boolean.FALSE;
            }
        });
        if (ignoreUpd != null && ignoreUpd.booleanValue()) {
            return true;
        }
        q = String.valueOf(DBPropertyUtil.Prefix.UPD.value()) + '.' + "%" + '.' + "KInfo%";
        String segment = (String)service.execute("select name,content from property where name like ?", new String[]{q}, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                while (rs.next()) {
                    String name = rs.getString("name");
                    String value = rs.getString("content");
                    if (name == null || name.length() == 0 || value == null || value.length() == 0) continue;
                    if (name.endsWith(".iban") && value.equals(k.getIban())) {
                        return name;
                    }
                    if (!name.endsWith(".KTV.number") || !value.equals(k.getKontonummer())) continue;
                    return name;
                }
                return null;
            }
        });
        if (segment == null || segment.length() == 0) {
            return false;
        }
        int pos = segment.indexOf(".KInfo");
        int offset = segment.substring(pos + 1).indexOf(46);
        segment = segment.substring(0, pos + offset + 1);
        q = String.valueOf(segment) + ".AllowedGV%.code";
        Boolean support = (Boolean)service.execute("select content from property where name like ? order by content", new String[]{q}, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                while (rs.next()) {
                    String code = rs.getString(1);
                    if (code == null || !code.equals(query.gvcode)) continue;
                    return true;
                }
                return false;
            }
        });
        return support;
    }

    private static TypedProperties getBPD(String kd, Query query, Integer version) throws RemoteException {
        final DBPropertyUtil.HBCITypedProperties props = new DBPropertyUtil.HBCITypedProperties();
        HBCIDBService service = Settings.getDBService();
        String prefix = String.valueOf(DBPropertyUtil.Prefix.BPD.value()) + '.' + kd.trim() + '.';
        String q = String.valueOf(prefix) + "Params%." + query.query + "Par" + (version != null ? version : "%") + ".Par" + query.query + "%";
        service.execute("select name,content from property where name like ? order by name", new String[]{q}, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String value = rs.getString(2);
                    if (name == null || value == null) continue;
                    name = name.substring(name.lastIndexOf(46) + 1);
                    props.put((Object)name, (Object)value);
                }
                return null;
            }
        });
        return props;
    }

    public static boolean updateCache(HBCIPassport passport, DBPropertyUtil.Prefix prefix) {
        Version v;
        long now;
        String user;
        Properties data;
        block14: {
            String version;
            block13: {
                if (passport == null) {
                    return false;
                }
                data = prefix == DBPropertyUtil.Prefix.BPD ? passport.getBPD() : passport.getUPD();
                version = prefix == DBPropertyUtil.Prefix.BPD ? passport.getBPDVersion() : passport.getUPDVersion();
                user = passport.getUserId();
                if (version != null && version.length() != 0 && user != null && user.length() != 0 && data != null && data.size() != 0) break block13;
                Logger.debug((String)("[" + (Object)((Object)prefix) + "] no version, no userid or no data found, skipping update"));
                return false;
            }
            now = System.currentTimeMillis();
            v = null;
            boolean expired = true;
            try {
                long timestamp = Long.parseLong(DBPropertyUtil.get(prefix, user, null, "cacheupdate", "0"));
                expired = timestamp == 0L || timestamp < now - 604800000L;
            }
            catch (Exception e) {
                Logger.write((Level)Level.DEBUG, (String)"unable to parse last cache-update date", (Throwable)e);
            }
            boolean newVersion = false;
            try {
                v = VersionUtil.getVersion(Settings.getDBService(), String.valueOf(prefix.value()) + "." + user);
                int nv = Integer.parseInt(version);
                int cv = v.getVersion();
                boolean bl = newVersion = nv > cv;
                if (cv < 0 || nv < 0) {
                    Logger.warn((String)("SUSPECT - " + (Object)((Object)prefix) + " version smaller than zero. new: " + nv + ", current: " + cv));
                }
                v.setVersion(nv);
            }
            catch (Exception e) {
                Logger.write((Level)Level.DEBUG, (String)"unable to parse version", (Throwable)e);
            }
            Logger.info((String)((Object)((Object)prefix) + " cache update state [expired: " + expired + ", new version: " + newVersion + "]"));
            if (expired || newVersion) break block14;
            return false;
        }
        try {
            ProgressMonitor monitor;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            SynchronizeSession session = ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).getCurrentSession();
            ProgressMonitor progressMonitor = monitor = session != null ? session.getProgressMonitor() : null;
            if (monitor != null) {
                monitor.log(i18n.tr("Aktualisiere " + prefix.name()));
            }
            Logger.info((String)("updating " + (Object)((Object)prefix) + " cache"));
            Set<String> customerIDs = HBCIProperties.getCustomerIDs(passport);
            int count = 1;
            for (String customerId : customerIDs) {
                DBPropertyUtil.Update update = DBPropertyUtil.updateScope(prefix, customerId, data);
                Logger.info((String)("customer " + count + ": updated " + (Object)((Object)prefix) + "- inserts: " + update.inserts + ", updates: " + update.updates + ", deletions: " + update.deletes));
                if (monitor != null) {
                    monitor.log(i18n.tr("  Kennung {0} - {1}-Parameter neu: {2}, ge\u00e4ndert: {3}, gel\u00f6scht: {4}", new String[]{Integer.toString(count), prefix.name(), Integer.toString(update.inserts), Integer.toString(update.updates), Integer.toString(update.deletes)}));
                }
                ++count;
            }
            v.store();
            DBPropertyUtil.set(prefix, user, null, "cacheupdate", Long.toString(now));
            return true;
        }
        catch (Exception e) {
            Logger.error((String)("error while updating " + (Object)((Object)prefix) + " - will be ignored"), (Throwable)e);
            return false;
        }
    }

    public static void expireCache(HBCIPassport passport, DBPropertyUtil.Prefix prefix) {
        String user = passport.getUserId();
        if (user == null || user.length() == 0) {
            Logger.debug((String)("[" + (Object)((Object)prefix) + "] no userid found, skipping cache expiry"));
            return;
        }
        try {
            Logger.info((String)("expire " + prefix.name() + " cache"));
            DBPropertyUtil.set(prefix, user, null, "cacheupdate", "0");
        }
        catch (Exception e) {
            Logger.error((String)("error while expiring " + (Object)((Object)prefix) + " cache"), (Throwable)e);
        }
    }

    public static enum Query {
        DauerEdit("DauerSEPAEdit", "HKCDN"),
        Kontoauszug("Kontoauszug", "HKEKA"),
        KontoauszugPdf("KontoauszugPdf", "HKEKP"),
        Umsatz("KUmsZeit", "HKKAZ"),
        UmsatzCamt("KUmsZeitCamt", "HKCAZ");

        private String query = null;
        private String gvcode = null;

        private Query(String query, String gvcode) {
            this.query = query;
            this.gvcode = gvcode;
        }
    }

    public static class Support {
        private Konto konto = null;
        private Query query = null;
        private Integer maxVersion = null;
        private boolean bpdSupport = false;
        private boolean updSupport = false;
        private TypedProperties bpd = null;

        private Support() {
        }

        public Konto getKonto() {
            return this.konto;
        }

        public Query getQuery() {
            return this.query;
        }

        public Integer getMaxVersion() {
            return this.maxVersion;
        }

        public boolean getBpdSupport() {
            return this.bpdSupport;
        }

        public boolean getUpdSupport() {
            return this.updSupport;
        }

        public boolean isSupported() {
            return this.updSupport && this.bpdSupport;
        }

        public TypedProperties getBpd() {
            return this.bpd;
        }
    }
}

