/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.hbci.Settings;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class Cache {
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(Cache.class);
    private static int timeout = 0;
    private static final Map<Class, Cache> caches = new HashMap<Class, Cache>();
    private Map<String, DBObject> data = new HashMap<String, DBObject>();
    private List<DBObject> values = new LinkedList<DBObject>();
    private Class<? extends DBObject> type = null;
    private long validTo = 0L;

    static {
        settings.setStoreWhenRead(false);
        timeout = settings.getInt("timeout.seconds", 10);
    }

    private Cache() {
        this.touch();
    }

    private void touch() {
        this.validTo = System.currentTimeMillis() + (long)(timeout * 1000);
    }

    static void clear(Class<? extends DBObject> type) {
        caches.remove(type);
    }

    static Cache get(final Class<? extends DBObject> type, boolean init) throws RemoteException {
        return Cache.get(type, new ObjectFactory(){

            @Override
            public DBIterator load() throws RemoteException {
                return Settings.getDBService().createList(type);
            }
        }, init);
    }

    static Cache get(Class<? extends DBObject> type, ObjectFactory factory, boolean init) throws RemoteException {
        Cache cache = caches.get(type);
        if (cache != null) {
            if (cache.validTo < System.currentTimeMillis()) {
                caches.remove(type);
                cache = null;
            } else {
                cache.touch();
            }
        }
        if (cache == null) {
            cache = new Cache();
            cache.type = type;
            if (init) {
                DBIterator list = factory.load();
                while (list.hasNext()) {
                    DBObject o = (DBObject)list.next();
                    cache.data.put(o.getID(), o);
                    cache.values.add(o);
                }
            }
            caches.put(type, cache);
        }
        return cache;
    }

    DBObject get(Object id) throws RemoteException {
        if (id == null) {
            return null;
        }
        String s = id.toString();
        DBObject value = this.data.get(s);
        if (value == null) {
            block5: {
                value = Settings.getDBService().createObject(this.type, s);
                if (value != null) break block5;
                return null;
            }
            try {
                this.data.put(value.getID(), value);
                this.values.add(value);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return value;
    }

    Collection<DBObject> values() {
        return this.values;
    }

    public static interface ObjectFactory {
        public DBIterator load() throws RemoteException;
    }
}

