/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.jost_net.OBanToo.SEPA.IBAN;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.hbci.server.SepaDauerauftragImpl;
import de.willuhn.jameica.hbci.server.TurnusHelper;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRKontoauszug;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

public class Converter {
    private static final double KURS_EUR = 1.95583;

    public static Umsatz HBCIUmsatz2HibiscusUmsatz(GVRKUms.UmsLine u) throws RemoteException {
        boolean haveName;
        String curr;
        Value v;
        Saldo s;
        Umsatz umsatz = (Umsatz)Settings.getDBService().createObject(Umsatz.class, null);
        umsatz.setArt(Converter.clean(u.text));
        umsatz.setCustomerRef(Converter.clean(u.customerref));
        umsatz.setPrimanota(Converter.clean(u.primanota));
        umsatz.setTransactionId(u.id);
        umsatz.setPurposeCode(u.purposecode);
        umsatz.setEndToEndId(u.endToEndId);
        umsatz.setMandateId(u.mandateId);
        if (u.other != null) {
            umsatz.setCreditorId(u.other.creditorid);
        }
        if ((s = u.saldo) != null && (v = s.value) != null) {
            double saldo = v.getDoubleValue();
            curr = v.getCurr();
            if (curr != null && "DEM".equals(curr)) {
                saldo /= 1.95583;
            }
            umsatz.setSaldo(saldo);
        }
        v = u.value;
        double betrag = v.getDoubleValue();
        curr = v.getCurr();
        if (curr != null && "DEM".equals(curr)) {
            betrag /= 1.95583;
        }
        umsatz.setBetrag(betrag);
        umsatz.setDatum(u.bdate);
        umsatz.setValuta(u.valuta);
        if (u.gvcode != null && !u.gvcode.equals("999") && u.gvcode.length() <= HBCIProperties.HBCI_GVCODE_MAXLENGTH) {
            umsatz.setGvCode(u.gvcode);
        }
        if (u.addkey != null && u.addkey.length() > 0 && u.addkey.length() <= HBCIProperties.HBCI_ADDKEY_MAXLENGTH) {
            umsatz.setAddKey(u.addkey);
        }
        String[] lines = u.usage.toArray(new String[0]);
        if (u.isCamt && u.usage != null) {
            if (u.usage.size() == 1) {
                umsatz.setZweck((String)u.usage.get(0));
            } else {
                VerwendungszweckUtil.applyCamt(umsatz, u.usage);
            }
        } else {
            String creditorId;
            String mid;
            if (lines.length == 0) {
                lines = VerwendungszweckUtil.parse(u.additional);
            }
            lines = VerwendungszweckUtil.rewrap(HBCIProperties.HBCI_TRANSFER_USAGE_DB_MAXLENGTH, lines);
            VerwendungszweckUtil.apply(umsatz, lines);
            String eref = umsatz.getEndToEndId();
            if ((eref == null || eref.length() == 0) && (eref = Converter.cleanSepaId(VerwendungszweckUtil.getTag(umsatz, VerwendungszweckUtil.Tag.EREF))) != null && eref.length() > 0 && eref.length() <= 100) {
                umsatz.setEndToEndId(eref);
            }
            if (((mid = umsatz.getMandateId()) == null || mid.length() == 0) && (mid = Converter.cleanSepaId(VerwendungszweckUtil.getTag(umsatz, VerwendungszweckUtil.Tag.MREF))) != null && mid.length() > 0 && mid.length() <= 100) {
                umsatz.setMandateId(mid);
            }
            if (((creditorId = umsatz.getCreditorId()) == null || creditorId.length() == 0) && (creditorId = Converter.cleanSepaId(VerwendungszweckUtil.getTag(umsatz, VerwendungszweckUtil.Tag.CRED))) != null && creditorId.length() > 0 && creditorId.length() <= HBCIProperties.HBCI_SEPA_CREDITORID_MAXLENGTH) {
                umsatz.setCreditorId(creditorId);
            }
        }
        if (u.other != null) {
            umsatz.setGegenkonto(Converter.HBCIKonto2Address(u.other, u.isCamt));
            if (u.isCamt) {
                umsatz.setGegenkontoName2(u.other.name2);
            }
        }
        if (!HBCIProperties.HBCI_SEPA_PARSE_TAGS) {
            return umsatz;
        }
        boolean haveIban = StringUtils.trimToNull((String)umsatz.getGegenkontoNummer()) != null;
        boolean haveBic = StringUtils.trimToNull((String)umsatz.getGegenkontoBLZ()) != null;
        boolean bl = haveName = StringUtils.trimToNull((String)umsatz.getGegenkontoName()) != null;
        if (!(haveIban && haveBic && haveName)) {
            Map<VerwendungszweckUtil.Tag, String> tags = VerwendungszweckUtil.parse(umsatz);
            if (!haveName) {
                umsatz.setGegenkontoName(tags.get((Object)VerwendungszweckUtil.Tag.ABWA));
            }
            String iban = tags.get((Object)VerwendungszweckUtil.Tag.IBAN);
            String bic = tags.get((Object)VerwendungszweckUtil.Tag.BIC);
            IBAN i = null;
            if (!haveIban && StringUtils.trimToNull((String)iban) != null) {
                try {
                    i = HBCIProperties.getIBAN(iban);
                    if (i != null) {
                        umsatz.setGegenkontoNummer(i.getIBAN());
                    }
                }
                catch (Exception e) {
                    Logger.error((String)("invalid IBAN - ignoring: " + iban), (Throwable)e);
                }
            }
            if (!haveBic) {
                if ((bic = StringUtils.trimToNull((String)bic)) != null) {
                    try {
                        bic = HBCIProperties.checkBIC(bic);
                        if (bic != null) {
                            umsatz.setGegenkontoBLZ(bic);
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)("invalid BIC - ignoring: " + bic), (Throwable)e);
                    }
                } else if (i != null) {
                    umsatz.setGegenkontoBLZ(i.getBIC());
                }
            }
        }
        return umsatz;
    }

    public static String cleanSepaId(String text) {
        if ((text = Converter.clean(text)) == null || text.length() == 0 || text.length() <= 100) {
            return text;
        }
        int pos = text.indexOf(32);
        if (pos > 0 && pos < 100) {
            text = text.substring(0, pos);
        }
        if (text.length() > 100) {
            text = text.substring(0, 100);
        }
        return text;
    }

    public static GVRKUms.UmsLine HibiscusUmsatz2HBCIUmsatz(Umsatz u) throws RemoteException {
        GVRKUms.UmsLine line = new GVRKUms.UmsLine();
        Konto k = u.getKonto();
        String iban = u.getGegenkontoNummer();
        String bic = u.getGegenkontoBLZ();
        boolean isSepa = iban != null && iban.length() > HBCIProperties.HBCI_KTO_MAXLENGTH_HARD;
        org.kapott.hbci.structures.Konto other = new org.kapott.hbci.structures.Konto();
        other.name = u.getGegenkontoName();
        if (isSepa) {
            other.iban = iban;
            other.bic = bic;
        } else {
            other.number = iban;
            other.blz = bic;
        }
        line.addkey = u.getAddKey();
        line.bdate = u.getDatum();
        line.customerref = u.getCustomerRef();
        line.gvcode = u.getGvCode();
        line.id = u.getTransactionId();
        line.isCamt = line.id != null && line.id.length() > 0;
        line.isSepa = isSepa;
        line.isStorno = false;
        line.other = other;
        line.primanota = u.getPrimanota();
        line.purposecode = u.getPurposeCode();
        line.saldo = new Saldo();
        line.saldo.timestamp = u.getDatum();
        line.saldo.value = new Value(new BigDecimal(u.getSaldo()), k.getWaehrung());
        line.text = u.getArt();
        line.usage = Arrays.asList(VerwendungszweckUtil.toArray(u));
        line.value = new Value(new BigDecimal(u.getBetrag()), k.getWaehrung());
        line.valuta = u.getValuta();
        return line;
    }

    private static String clean(String s) {
        return HBCIProperties.replace(s, HBCIProperties.TEXT_REPLACEMENTS_UMSATZ);
    }

    public static SepaDauerauftrag HBCIDauer2HibiscusSepaDauerauftrag(GVRDauerList.Dauer d) throws RemoteException, ApplicationException {
        SepaDauerauftragImpl auftrag = (SepaDauerauftragImpl)Settings.getDBService().createObject(SepaDauerauftrag.class, null);
        auftrag.setErsteZahlung(d.firstdate);
        auftrag.setLetzteZahlung(d.lastdate);
        auftrag.setKonto(Converter.HBCIKonto2HibiscusKonto(d.my));
        auftrag.setBetrag(d.value.getDoubleValue());
        auftrag.setOrderID(d.orderid);
        auftrag.setGegenkonto(Converter.HBCIKonto2Address(d.other));
        auftrag.setChangable(d.can_change);
        auftrag.setDeletable(d.can_delete);
        auftrag.setPmtInfId(d.pmtinfid);
        auftrag.setPurposeCode(d.purposecode);
        VerwendungszweckUtil.apply(auftrag, d.usage);
        if (auftrag.getZweck() == null) {
            auftrag.setZweck("-");
        }
        auftrag.setTurnus(TurnusHelper.createByDauerAuftrag(d));
        return auftrag;
    }

    public static Kontoauszug HBCIKontoauszug2HibiscusKontoauszug(Konto kt, GVRKontoauszug.GVRKontoauszugEntry k) throws RemoteException, ApplicationException {
        Integer n;
        Kontoauszug newest;
        Kontoauszug kh = (Kontoauszug)Settings.getDBService().createObject(Kontoauszug.class, null);
        Date createDate = k.getDate();
        Date startDate = k.getStartDate();
        Date endDate = k.getEndDate();
        kh.setVon(startDate);
        kh.setBis(endDate);
        kh.setErstellungsdatum(createDate);
        GVRKontoauszug.Format f = k.getFormat();
        kh.setFormat(f != null ? f.getCode() : null);
        int year = k.getYear();
        if (year == 0) {
            year = Converter.getYear(startDate);
        }
        if (year == 0) {
            year = Converter.getYear(endDate);
        }
        if (year == 0) {
            year = Converter.getYear(createDate);
        }
        if (year == 0) {
            year = Converter.getYear(new Date());
        }
        kh.setJahr(year > 0 ? Integer.valueOf(year) : null);
        kh.setKonto(kt);
        kh.setName1(k.getName());
        kh.setName2(k.getName2());
        kh.setName3(k.getName3());
        int number = k.getNumber();
        if (number == 0 && (newest = KontoauszugPdfUtil.getNewestWithNumber(kt)) != null && (n = newest.getNummer()) != null) {
            number = n + 1;
        }
        kh.setNummer(number > 0 ? Integer.valueOf(number) : null);
        kh.setDateiname(k.getFilename());
        kh.setQuittungscode(k.getReceipt());
        return kh;
    }

    private static int getYear(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static org.kapott.hbci.structures.Konto HibiscusKonto2HBCIKonto(Konto konto) throws RemoteException {
        org.kapott.hbci.structures.Konto k = new org.kapott.hbci.structures.Konto(konto.getBLZ(), konto.getKontonummer());
        k.country = "DE";
        k.curr = konto.getWaehrung();
        k.customerid = konto.getKundennummer();
        k.type = konto.getBezeichnung();
        k.name = konto.getName();
        k.subnumber = konto.getUnterkonto();
        k.iban = konto.getIban();
        k.bic = konto.getBic();
        Integer accType = konto.getAccountType();
        k.acctype = accType != null ? accType.toString() : null;
        return k;
    }

    public static Konto HBCIKonto2HibiscusKonto(org.kapott.hbci.structures.Konto konto, Class passportClass) throws RemoteException {
        DBIterator list = Settings.getDBService().createList(Konto.class);
        list.addFilter("kontonummer = ?", new Object[]{konto.number});
        list.addFilter("blz = ?", new Object[]{konto.blz});
        if (passportClass != null) {
            list.addFilter("passport_class = ?", new Object[]{passportClass.getName()});
        }
        if (konto.subnumber != null && konto.subnumber.length() > 0) {
            list.addFilter("unterkonto = ?", new Object[]{konto.subnumber});
        }
        if (konto.customerid != null && konto.customerid.length() > 0) {
            list.addFilter("kundennummer = ?", new Object[]{konto.customerid});
        }
        String type = StringUtils.trimToNull((String)konto.acctype);
        Integer accType = null;
        if (type != null) {
            try {
                accType = Integer.parseInt(type);
            }
            catch (Exception e) {
                Logger.error((String)("unknown account type: " + type), (Throwable)e);
            }
        }
        if (accType != null) {
            list.addFilter("acctype = ?", new Object[]{accType});
        }
        if (list.hasNext()) {
            return (Konto)list.next();
        }
        Konto k = (Konto)Settings.getDBService().createObject(Konto.class, null);
        k.setBLZ(konto.blz);
        k.setKontonummer(konto.number);
        k.setUnterkonto(konto.subnumber);
        k.setKundennummer(konto.customerid);
        k.setName(konto.name);
        k.setBezeichnung(konto.type);
        k.setWaehrung(konto.curr);
        k.setIban(konto.iban);
        k.setAccountType(accType);
        k.setBic(konto.bic);
        if (passportClass != null) {
            k.setPassportClass(passportClass.getName());
        }
        return k;
    }

    public static Konto HBCIKonto2HibiscusKonto(org.kapott.hbci.structures.Konto konto) throws RemoteException {
        return Converter.HBCIKonto2HibiscusKonto(konto, null);
    }

    public static org.kapott.hbci.structures.Konto Address2HBCIKonto(Address adresse) throws RemoteException {
        org.kapott.hbci.structures.Konto k = new org.kapott.hbci.structures.Konto("DE", adresse.getBlz(), adresse.getKontonummer());
        k.name = adresse.getName();
        k.iban = adresse.getIban();
        k.bic = adresse.getBic();
        return k;
    }

    public static HibiscusAddress HBCIKonto2Address(org.kapott.hbci.structures.Konto konto, boolean camt) throws RemoteException {
        String name2;
        HibiscusAddress e = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, null);
        e.setBlz(konto.blz);
        e.setKontonummer(konto.number);
        e.setBic(konto.bic);
        e.setIban(konto.iban);
        String name = StringUtils.trimToEmpty((String)konto.name);
        if (!camt && (name2 = StringUtils.trimToEmpty((String)konto.name2)) != null && name2.length() > 0) {
            name = String.valueOf(name) + " " + name2;
        }
        if (name != null && name.length() > HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH) {
            name = StringUtils.trimToEmpty((String)name.substring(0, HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH));
        }
        e.setName(name);
        return e;
    }

    public static HibiscusAddress HBCIKonto2Address(org.kapott.hbci.structures.Konto konto) throws RemoteException {
        return Converter.HBCIKonto2Address(konto, false);
    }
}

