/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.DBProperty;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.TypedProperties;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ObjectUtils;

public class DBPropertyUtil {
    private static final de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(DBPropertyUtil.class);
    private static int timeout = 0;
    private static Cache<String, Map<String, DBProperty>> CACHE = null;
    public static final char SEP = '.';
    public static final String KEY_CACHE_UPDATE = "cacheupdate";

    static {
        timeout = settings.getInt("timeout.seconds", 10);
        DBPropertyUtil.logCache("init [timeout: " + timeout + " seconds]");
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.expireAfterWrite((long)timeout, TimeUnit.SECONDS);
        CACHE = builder.build();
    }

    public static boolean insert(Prefix prefix, String scope, String id, String name, String value) throws RemoteException {
        if (value == null) {
            return false;
        }
        if (prefix == null) {
            Logger.warn((String)"prefix missing");
            return false;
        }
        if (scope == null || scope.length() == 0) {
            Logger.warn((String)"scope missing");
            return false;
        }
        if (name == null || name.length() == 0) {
            Logger.warn((String)"name missing");
            return false;
        }
        Set<String> filters = prefix.getFilter();
        if (filters != null && filters.size() > 0) {
            boolean found = false;
            for (String filter : filters) {
                if (!name.contains(filter)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        try {
            String localName = DBPropertyUtil.createIdentifier(prefix, scope, id, name);
            HBCIDBService service = Settings.getDBService();
            DBProperty prop = (DBProperty)service.createObject(DBProperty.class, null);
            prop.setName(localName);
            prop.setValue(value);
            prop.store();
            Map cache = (Map)CACHE.getIfPresent((Object)DBPropertyUtil.createScopeIdentifier(prefix, scope));
            if (cache != null) {
                DBPropertyUtil.logCache("added " + localName + "=" + value);
                cache.put(localName, prop);
            }
            return true;
        }
        catch (ApplicationException ae) {
            throw new RemoteException(ae.getMessage(), ae);
        }
    }

    private static String createIdentifier(Prefix prefix, String scope, String id, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(DBPropertyUtil.createScopeIdentifier(prefix, scope));
        if (id != null && id.length() > 0) {
            sb.append(DBPropertyUtil.replaceWildcards(id));
            sb.append('.');
        }
        if (name != null && name.length() > 0) {
            sb.append(name);
        }
        return sb.toString();
    }

    private static String createScopeIdentifier(Prefix prefix, String scope) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix.value());
            sb.append('.');
        }
        if (scope != null && scope.length() > 0) {
            sb.append(DBPropertyUtil.replaceWildcards(scope));
            sb.append('.');
        }
        return sb.toString();
    }

    public static void set(Prefix prefix, String scope, String id, String name, String value) throws RemoteException {
        String localname = DBPropertyUtil.createIdentifier(prefix, scope, id, name);
        DBProperty prop = DBPropertyUtil.find(localname);
        if (prop == null) {
            Logger.warn((String)("parameter name " + localname + " invalid"));
            return;
        }
        try {
            Map cache = (Map)CACHE.getIfPresent((Object)DBPropertyUtil.createScopeIdentifier(prefix, scope));
            if (value == null) {
                if (!prop.isNewObject()) {
                    prop.delete();
                    if (cache != null) {
                        DBPropertyUtil.logCache("removed " + localname);
                        cache.remove(localname);
                    }
                }
                return;
            }
            prop.setValue(value);
            prop.store();
            if (cache != null) {
                DBPropertyUtil.logCache("added " + localname + "=" + value);
                cache.put(localname, prop);
            }
        }
        catch (ApplicationException ae) {
            throw new RemoteException(ae.getMessage(), ae);
        }
    }

    public static String get(final Prefix prefix, final String scope, String id, String name, String defaultValue) throws RemoteException {
        String localName = DBPropertyUtil.createIdentifier(prefix, scope, id, name);
        DBProperty prop = null;
        boolean cacheChecked = false;
        try {
            final String localPrefix = DBPropertyUtil.createScopeIdentifier(prefix, scope);
            Map cache = (Map)CACHE.get((Object)localPrefix, (Callable)new Callable<Map<String, DBProperty>>(){

                @Override
                public Map<String, DBProperty> call() throws Exception {
                    DBPropertyUtil.logCache("loaded scope " + localPrefix);
                    return DBPropertyUtil.getScope(prefix, scope);
                }
            });
            prop = (DBProperty)cache.get(localName);
            cacheChecked = true;
        }
        catch (Exception e) {
            Logger.error((String)"cache lookup error", (Throwable)e);
        }
        if (prop == null && !cacheChecked) {
            prop = DBPropertyUtil.find(localName);
        }
        if (prop == null) {
            return defaultValue;
        }
        String value = prop.getValue();
        return value != null ? value : defaultValue;
    }

    public static int deleteAll(Prefix prefix) throws RemoteException {
        if (prefix == null) {
            throw new RemoteException("no prefix given");
        }
        int count = Settings.getDBService().executeUpdate("delete from property where name like ?", String.valueOf(prefix.value()) + ".%");
        DBPropertyUtil.logCache("invalidate cache");
        CACHE.invalidateAll();
        return count;
    }

    public static int deleteScope(Prefix prefix, String scope) throws RemoteException {
        if (prefix == null) {
            throw new RemoteException("no prefix given");
        }
        if (scope == null || scope.length() == 0) {
            throw new RemoteException("no scope given");
        }
        String localPrefix = DBPropertyUtil.createScopeIdentifier(prefix, scope);
        int count = Settings.getDBService().executeUpdate("delete from property where name like ?", String.valueOf(localPrefix) + "%");
        DBPropertyUtil.logCache("invalidate scope " + localPrefix);
        CACHE.invalidate((Object)localPrefix);
        return count;
    }

    private static Map<String, DBProperty> getScope(Prefix prefix, String scope) throws RemoteException {
        if (prefix == null) {
            throw new RemoteException("no prefix given");
        }
        if (scope == null || scope.length() == 0) {
            throw new RemoteException("no scope given");
        }
        scope = DBPropertyUtil.replaceWildcards(scope);
        String localPrefix = DBPropertyUtil.createScopeIdentifier(prefix, scope);
        DBIterator list = Settings.getDBService().createList(DBProperty.class);
        list.addFilter("name like ?", new Object[]{String.valueOf(localPrefix) + "%"});
        HashMap<String, DBProperty> result = new HashMap<String, DBProperty>();
        while (list.hasNext()) {
            DBProperty prop = (DBProperty)list.next();
            String name = prop.getName();
            if (ObjectUtils.equals((Object)name, (Object)DBPropertyUtil.createIdentifier(prefix, scope, null, KEY_CACHE_UPDATE))) continue;
            result.put(name, prop);
        }
        return result;
    }

    public static Update updateScope(Prefix prefix, String scope, Properties update) throws RemoteException {
        Update result = new Update();
        if (prefix == null) {
            Logger.warn((String)"no prefix given");
            return result;
        }
        if (update == null || update.size() == 0) {
            Logger.warn((String)"no update given");
            return result;
        }
        if (scope == null || scope.length() == 0) {
            Logger.warn((String)"no scope given");
            return result;
        }
        scope = DBPropertyUtil.replaceWildcards(scope);
        Map<String, DBProperty> current = DBPropertyUtil.getScope(prefix, scope);
        HashSet<String> updateKeys = new HashSet<String>();
        Enumeration<Object> keys = update.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String localname = DBPropertyUtil.createIdentifier(prefix, scope, null, name);
            updateKeys.add(localname);
            DBProperty oldValue = current.get(localname);
            String updateValue = update.getProperty(name);
            if (oldValue != null) {
                if (ObjectUtils.equals((Object)oldValue.getValue(), (Object)updateValue)) continue;
                oldValue.setValue(updateValue);
                try {
                    oldValue.store();
                    ++result.updates;
                    continue;
                }
                catch (ApplicationException ae) {
                    throw new RemoteException(ae.getMessage(), ae);
                }
            }
            if (!DBPropertyUtil.insert(prefix, scope, null, name, updateValue)) continue;
            ++result.inserts;
        }
        for (Map.Entry<String, DBProperty> e : current.entrySet()) {
            if (updateKeys.contains(e.getKey())) continue;
            result.deletes += Settings.getDBService().executeUpdate("delete from property where name = ?", e.getKey());
        }
        String localPrefix = DBPropertyUtil.createScopeIdentifier(prefix, scope);
        DBPropertyUtil.logCache("invalidate scope " + localPrefix);
        CACHE.invalidate((Object)localPrefix);
        return result;
    }

    public static int delete(Prefix prefix, String scope, String id) throws RemoteException {
        if (prefix == null) {
            throw new RemoteException("no prefix given");
        }
        if (scope == null || scope.length() == 0) {
            throw new RemoteException("no scope given");
        }
        String localPrefix = DBPropertyUtil.createIdentifier(prefix, scope, id, null);
        int count = Settings.getDBService().executeUpdate("delete from property where name like ?", String.valueOf(localPrefix) + "%");
        String localPrefix2 = DBPropertyUtil.createScopeIdentifier(prefix, scope);
        DBPropertyUtil.logCache("invalidate scope " + localPrefix2);
        CACHE.invalidate((Object)localPrefix2);
        return count;
    }

    private static DBProperty find(String name) throws RemoteException {
        if (name == null) {
            return null;
        }
        HBCIDBService service = Settings.getDBService();
        DBIterator i = service.createList(DBProperty.class);
        i.addFilter("name = ?", new Object[]{name});
        if (i.hasNext()) {
            return (DBProperty)i.next();
        }
        DBProperty prop = (DBProperty)service.createObject(DBProperty.class, null);
        prop.setName(name);
        return prop;
    }

    private static void logCache(String msg) {
        Logger.debug((String)("*** [CACHE] " + msg));
    }

    private static String replaceWildcards(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        s = s.replace("%", "-");
        s = s.replace("_", "-");
        return s;
    }

    public static class HBCITypedProperties
    extends TypedProperties {
        public boolean getBoolean(String name, boolean defaultValue) {
            String s = super.getProperty(name, defaultValue ? "J" : "N");
            return "J".equalsIgnoreCase(s);
        }
    }

    public static enum Prefix {
        BPD("bpd", new HashSet<String>(Arrays.asList("DauerSEPAEditPar", "KontoauszugPar", "KontoauszugPdfPar", "KUmsZeitCamtPar"))),
        UPD("upd", new HashSet<String>(Arrays.asList("KInfo", "UPA"))),
        META("meta", null),
        UNREAD("unread", null);

        private String value = null;
        private Set<String> filter = null;

        private Prefix(String value, Set<String> filter) {
            this.value = value;
            this.filter = filter;
        }

        public String value() {
            return this.value;
        }

        private Set<String> getFilter() {
            return this.filter;
        }
    }

    public static class Update {
        public int inserts = 0;
        public int updates = 0;
        public int deletes = 0;
    }
}

