/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.DBReminder;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;

public class DBReminderImpl
extends AbstractHibiscusDBObject
implements DBReminder {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected void insertCheck() throws ApplicationException {
        try {
            if (StringUtils.trimToNull((String)this.getUUID()) == null) {
                throw new ApplicationException(i18n.tr("Keine UUID angegeben."));
            }
            if (this.getReminder() == null) {
                throw new ApplicationException(i18n.tr("Kein Reminder angegeben"));
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while insertcheck", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler bei der Pr\u00fcfung der Daten"));
        }
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public String getUUID() throws RemoteException {
        return (String)this.getAttribute("uuid");
    }

    @Override
    public void setUUID(String uuid) throws RemoteException {
        this.setAttribute("uuid", uuid);
    }

    @Override
    public Reminder getReminder() throws RemoteException {
        String serialized = (String)this.getAttribute("content");
        if (serialized == null || serialized.length() == 0) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(serialized.getBytes("UTF-8")));){
                return (Reminder)decoder.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RemoteException("unable to unserialize reminder", e);
        }
    }

    @Override
    public void setReminder(Reminder reminder) throws RemoteException {
        if (reminder == null) {
            this.setAttribute("content", null);
            return;
        }
        XMLEncoder encoder = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            encoder = new XMLEncoder(os);
            encoder.writeObject(reminder);
            encoder.close();
            this.setAttribute("content", os.toString("UTF-8"));
        }
        catch (Exception e) {
            throw new RemoteException("unable to serialize reminder", e);
        }
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "uuid";
    }

    protected String getTableName() {
        return "reminder";
    }
}

