/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.server.AbstractDBSupportImpl;
import de.willuhn.jameica.hbci.server.HBCIDBServiceImpl;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.sql.Connection;

public class DBSupportH2Impl
extends AbstractDBSupportImpl {
    public DBSupportH2Impl() {
        Logger.info((String)"switching dbservice to uppercase");
        System.setProperty(String.valueOf(HBCIDBServiceImpl.class.getName()) + ".uppercase", "true");
        try {
            Method m = Class.forName("org.h2.engine.Constants").getMethod("getVersion", null);
            Logger.info((String)("h2 version: " + m.invoke(null, null)));
        }
        catch (Throwable t) {
            Logger.warn((String)"unable to determine h2 version");
        }
    }

    @Override
    public String getJdbcDriver() {
        return "org.h2.Driver";
    }

    @Override
    public String getJdbcPassword() {
        String password = HBCIDBService.SETTINGS.getString("database.driver.h2.encryption.encryptedpassword", null);
        try {
            if (password == null) {
                Logger.info((String)"generating new random password for database");
                byte[] data = new byte[20];
                SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                random.nextBytes(data);
                Logger.info((String)"encrypting password with system certificate");
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Application.getSSLFactory().encrypt((InputStream)new ByteArrayInputStream(data), (OutputStream)bos);
                HBCIDBService.SETTINGS.setAttribute("database.driver.h2.encryption.encryptedpassword", Base64.encode((byte[])bos.toByteArray()));
                String encoded = Base64.encode((byte[])data);
                return String.valueOf(encoded) + " " + encoded;
            }
            Logger.debug((String)"decrypting database password");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Application.getSSLFactory().decrypt((InputStream)new ByteArrayInputStream(Base64.decode((String)password)), (OutputStream)bos);
            String encoded = Base64.encode((byte[])bos.toByteArray());
            return String.valueOf(encoded) + " " + encoded;
        }
        catch (Exception e) {
            throw new RuntimeException("error while determining database password", e);
        }
    }

    @Override
    public String getJdbcUrl() {
        String addon;
        String url = "jdbc:h2:" + Application.getPluginLoader().getPlugin(HBCI.class).getResources().getWorkPath() + "/h2db/hibiscus";
        if (HBCIDBService.SETTINGS.getBoolean("database.driver.h2.encryption", true)) {
            url = String.valueOf(url) + ";CIPHER=" + HBCIDBService.SETTINGS.getString("database.driver.h2.encryption.algorithm", "XTEA");
        }
        if (HBCIDBService.SETTINGS.getBoolean("database.driver.h2.recover", false)) {
            Logger.warn((String)"#############################################################");
            Logger.warn((String)"## DATABASE RECOVERY ACTIVATED                             ##");
            Logger.warn((String)"#############################################################");
            url = String.valueOf(url) + ";RECOVER=1";
        }
        if ((addon = HBCIDBService.SETTINGS.getString("database.driver.h2.parameters", null)) != null) {
            url = String.valueOf(url) + ";" + addon;
        }
        return url;
    }

    @Override
    public String getJdbcUsername() {
        return "hibiscus";
    }

    @Override
    public String getScriptPrefix() throws RemoteException {
        return "h2-";
    }

    @Override
    public String getSQLTimestamp(String content) throws RemoteException {
        return content;
    }

    @Override
    public boolean getInsertWithID() throws RemoteException {
        return false;
    }

    @Override
    public void checkConnection(Connection conn) throws RemoteException {
    }
}

