/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.server.AbstractDBSupportImpl;
import de.willuhn.jameica.messaging.BootMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.text.MessageFormat;

public class DBSupportMySqlImpl
extends AbstractDBSupportImpl {
    private static final String DRIVER = "org.mariadb.jdbc.Driver";

    @Override
    public String getJdbcDriver() {
        return HBCIDBService.SETTINGS.getString("database.driver.mysql.jdbcdriver", DRIVER);
    }

    @Override
    public String getJdbcPassword() {
        return this.getEncrypted("database.driver.mysql.password");
    }

    @Override
    public String getJdbcUrl() {
        return HBCIDBService.SETTINGS.getString("database.driver.mysql.jdbcurl", "jdbc:mariadb://localhost:3306/hibiscus?useUnicode=Yes&characterEncoding=ISO8859_1&serverTimezone=Europe/Paris");
    }

    @Override
    public String getJdbcUsername() {
        return HBCIDBService.SETTINGS.getString("database.driver.mysql.username", "hibiscus");
    }

    @Override
    public void execute(Connection conn, File sqlScript) throws RemoteException {
        if (sqlScript == null) {
            return;
        }
        File f = new File(sqlScript.getParent(), String.valueOf(this.getScriptPrefix()) + sqlScript.getName());
        if (f.exists()) {
            I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
            String text = i18n.tr("Bei der Verwendung von MySQL wird die Datenbank nicht automatisch angelegt. Bitte f\u00fchren Sie das folgende SQL-Script manuell aus, falls Sie dies nicht bereits getan haben:\n{0}", f.getAbsolutePath());
            BootMessage msg = new BootMessage(text);
            msg.setTitle(i18n.tr("Hinweis zur Verwendung von MySQL"));
            Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage((Message)msg);
        }
    }

    @Override
    public String getScriptPrefix() throws RemoteException {
        return "mysql-";
    }

    @Override
    public String getSQLTimestamp(String content) throws RemoteException {
        return MessageFormat.format("(UNIX_TIMESTAMP({0})*1000)", content);
    }

    @Override
    public boolean getInsertWithID() throws RemoteException {
        return false;
    }

    @Override
    public int getTransactionIsolationLevel() throws RemoteException {
        return 2;
    }
}

